package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JWTRuleBuilder extends JWTRuleFluentImpl<JWTRuleBuilder> implements VisitableBuilder<JWTRule,io.fabric8.istio.api.security.v1beta1.JWTRuleBuilder>{
  public JWTRuleBuilder() {
    this(false);
  }
  public JWTRuleBuilder(Boolean validationEnabled) {
    this(new JWTRule(), validationEnabled);
  }
  public JWTRuleBuilder(io.fabric8.istio.api.security.v1beta1.JWTRuleFluent<?> fluent) {
    this(fluent, false);
  }
  public JWTRuleBuilder(io.fabric8.istio.api.security.v1beta1.JWTRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JWTRule(), validationEnabled);
  }
  public JWTRuleBuilder(io.fabric8.istio.api.security.v1beta1.JWTRuleFluent<?> fluent,io.fabric8.istio.api.security.v1beta1.JWTRule instance) {
    this(fluent, instance, false);
  }
  public JWTRuleBuilder(io.fabric8.istio.api.security.v1beta1.JWTRuleFluent<?> fluent,io.fabric8.istio.api.security.v1beta1.JWTRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAudiences(instance.getAudiences()); 
    fluent.withForwardOriginalToken(instance.getForwardOriginalToken()); 
    fluent.withFromHeaders(instance.getFromHeaders()); 
    fluent.withFromParams(instance.getFromParams()); 
    fluent.withIssuer(instance.getIssuer()); 
    fluent.withJwks(instance.getJwks()); 
    fluent.withJwksUri(instance.getJwksUri()); 
    fluent.withOutputPayloadToHeader(instance.getOutputPayloadToHeader()); 
    this.validationEnabled = validationEnabled; 
  }
  public JWTRuleBuilder(io.fabric8.istio.api.security.v1beta1.JWTRule instance) {
    this(instance,false);
  }
  public JWTRuleBuilder(io.fabric8.istio.api.security.v1beta1.JWTRule instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAudiences(instance.getAudiences()); 
    this.withForwardOriginalToken(instance.getForwardOriginalToken()); 
    this.withFromHeaders(instance.getFromHeaders()); 
    this.withFromParams(instance.getFromParams()); 
    this.withIssuer(instance.getIssuer()); 
    this.withJwks(instance.getJwks()); 
    this.withJwksUri(instance.getJwksUri()); 
    this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader()); 
    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.istio.api.security.v1beta1.JWTRuleFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.istio.api.security.v1beta1.JWTRule build() {
    JWTRule buildable = new JWTRule(fluent.getAudiences(),fluent.getForwardOriginalToken(),fluent.getFromHeaders(),fluent.getFromParams(),fluent.getIssuer(),fluent.getJwks(),fluent.getJwksUri(),fluent.getOutputPayloadToHeader());
    return buildable;
  }
  
}