package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JWTRuleFluentImpl<A extends JWTRuleFluent<A>> extends BaseFluent<A> implements JWTRuleFluent<A>{
  public JWTRuleFluentImpl() {
  }
  public JWTRuleFluentImpl(io.fabric8.istio.api.security.v1beta1.JWTRule instance) {
    this.withAudiences(instance.getAudiences()); 
    this.withForwardOriginalToken(instance.getForwardOriginalToken()); 
    this.withFromHeaders(instance.getFromHeaders()); 
    this.withFromParams(instance.getFromParams()); 
    this.withIssuer(instance.getIssuer()); 
    this.withJwks(instance.getJwks()); 
    this.withJwksUri(instance.getJwksUri()); 
    this.withOutputPayloadToHeader(instance.getOutputPayloadToHeader()); 
  }
  private List<String> audiences = new ArrayList<java.lang.String>();
  private Boolean forwardOriginalToken;
  private java.util.ArrayList<JWTHeaderBuilder> fromHeaders = new java.util.ArrayList<JWTHeaderBuilder>();
  private java.util.List<java.lang.String> fromParams = new java.util.ArrayList<java.lang.String>();
  private java.lang.String issuer;
  private java.lang.String jwks;
  private java.lang.String jwksUri;
  private java.lang.String outputPayloadToHeader;
  public A addToAudiences(Integer index,java.lang.String item) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  public A setToAudiences(java.lang.Integer index,java.lang.String item) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    this.audiences.set(index, item); return (A)this;
  }
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A addAllToAudiences(Collection<java.lang.String> items) {
    if (this.audiences == null) {this.audiences = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A removeFromAudiences(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public A removeAllFromAudiences(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.audiences!= null){ this.audiences.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getAudiences() {
    return this.audiences;
  }
  public java.lang.String getAudience(java.lang.Integer index) {
    return this.audiences.get(index);
  }
  public java.lang.String getFirstAudience() {
    return this.audiences.get(0);
  }
  public java.lang.String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  public java.lang.String getMatchingAudience(Predicate<java.lang.String> predicate) {
    for (java.lang.String item: audiences) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingAudience(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: audiences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAudiences(java.util.List<java.lang.String> audiences) {
    if (audiences != null) {this.audiences = new java.util.ArrayList(); for (java.lang.String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
  }
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {this.audiences.clear();}
    if (audiences != null) {for (java.lang.String item :audiences){ this.addToAudiences(item);}} return (A) this;
  }
  public java.lang.Boolean hasAudiences() {
    return audiences != null && !audiences.isEmpty();
  }
  public java.lang.Boolean getForwardOriginalToken() {
    return this.forwardOriginalToken;
  }
  public A withForwardOriginalToken(java.lang.Boolean forwardOriginalToken) {
    this.forwardOriginalToken=forwardOriginalToken; return (A) this;
  }
  public java.lang.Boolean hasForwardOriginalToken() {
    return this.forwardOriginalToken != null;
  }
  public A addToFromHeaders(java.lang.Integer index,io.fabric8.istio.api.security.v1beta1.JWTHeader item) {
    if (this.fromHeaders == null) {this.fromHeaders = new java.util.ArrayList<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder>();}
    io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(item);_visitables.get("fromHeaders").add(index >= 0 ? index : _visitables.get("fromHeaders").size(), builder);this.fromHeaders.add(index >= 0 ? index : fromHeaders.size(), builder); return (A)this;
  }
  public A setToFromHeaders(java.lang.Integer index,io.fabric8.istio.api.security.v1beta1.JWTHeader item) {
    if (this.fromHeaders == null) {this.fromHeaders = new java.util.ArrayList<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder>();}
    io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(item);
    if (index < 0 || index >= _visitables.get("fromHeaders").size()) { _visitables.get("fromHeaders").add(builder); } else { _visitables.get("fromHeaders").set(index, builder);}
    if (index < 0 || index >= fromHeaders.size()) { fromHeaders.add(builder); } else { fromHeaders.set(index, builder);}
     return (A)this;
  }
  public A addToFromHeaders(io.fabric8.istio.api.security.v1beta1.JWTHeader... items) {
    if (this.fromHeaders == null) {this.fromHeaders = new java.util.ArrayList<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder>();}
    for (io.fabric8.istio.api.security.v1beta1.JWTHeader item : items) {io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(item);_visitables.get("fromHeaders").add(builder);this.fromHeaders.add(builder);} return (A)this;
  }
  public A addAllToFromHeaders(java.util.Collection<io.fabric8.istio.api.security.v1beta1.JWTHeader> items) {
    if (this.fromHeaders == null) {this.fromHeaders = new java.util.ArrayList<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder>();}
    for (io.fabric8.istio.api.security.v1beta1.JWTHeader item : items) {io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(item);_visitables.get("fromHeaders").add(builder);this.fromHeaders.add(builder);} return (A)this;
  }
  public A removeFromFromHeaders(io.fabric8.istio.api.security.v1beta1.JWTHeader... items) {
    for (io.fabric8.istio.api.security.v1beta1.JWTHeader item : items) {io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(item);_visitables.get("fromHeaders").remove(builder);if (this.fromHeaders != null) {this.fromHeaders.remove(builder);}} return (A)this;
  }
  public A removeAllFromFromHeaders(java.util.Collection<io.fabric8.istio.api.security.v1beta1.JWTHeader> items) {
    for (io.fabric8.istio.api.security.v1beta1.JWTHeader item : items) {io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(item);_visitables.get("fromHeaders").remove(builder);if (this.fromHeaders != null) {this.fromHeaders.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromFromHeaders(java.util.function.Predicate<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder> predicate) {
    if (fromHeaders == null) return (A) this;
    final Iterator<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder> each = fromHeaders.iterator();
    final List visitables = _visitables.get("fromHeaders");
    while (each.hasNext()) {
      io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildFromHeaders instead.
   * @return The buildable object.
   */
  @Deprecated
  public java.util.List<io.fabric8.istio.api.security.v1beta1.JWTHeader> getFromHeaders() {
    return fromHeaders != null ? build(fromHeaders) : null;
  }
  public java.util.List<io.fabric8.istio.api.security.v1beta1.JWTHeader> buildFromHeaders() {
    return fromHeaders != null ? build(fromHeaders) : null;
  }
  public io.fabric8.istio.api.security.v1beta1.JWTHeader buildFromHeader(java.lang.Integer index) {
    return this.fromHeaders.get(index).build();
  }
  public io.fabric8.istio.api.security.v1beta1.JWTHeader buildFirstFromHeader() {
    return this.fromHeaders.get(0).build();
  }
  public io.fabric8.istio.api.security.v1beta1.JWTHeader buildLastFromHeader() {
    return this.fromHeaders.get(fromHeaders.size() - 1).build();
  }
  public io.fabric8.istio.api.security.v1beta1.JWTHeader buildMatchingFromHeader(java.util.function.Predicate<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder> predicate) {
    for (io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder item: fromHeaders) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingFromHeader(java.util.function.Predicate<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder> predicate) {
    for (io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder item: fromHeaders) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFromHeaders(java.util.List<io.fabric8.istio.api.security.v1beta1.JWTHeader> fromHeaders) {
    if (this.fromHeaders != null) { _visitables.get("fromHeaders").removeAll(this.fromHeaders);}
    if (fromHeaders != null) {this.fromHeaders = new java.util.ArrayList(); for (io.fabric8.istio.api.security.v1beta1.JWTHeader item : fromHeaders){this.addToFromHeaders(item);}} else { this.fromHeaders = null;} return (A) this;
  }
  public A withFromHeaders(io.fabric8.istio.api.security.v1beta1.JWTHeader... fromHeaders) {
    if (this.fromHeaders != null) {this.fromHeaders.clear();}
    if (fromHeaders != null) {for (io.fabric8.istio.api.security.v1beta1.JWTHeader item :fromHeaders){ this.addToFromHeaders(item);}} return (A) this;
  }
  public java.lang.Boolean hasFromHeaders() {
    return fromHeaders != null && !fromHeaders.isEmpty();
  }
  public A addNewFromHeader(java.lang.String name,java.lang.String prefix) {
    return (A)addToFromHeaders(new JWTHeader(name, prefix));
  }
  public JWTRuleFluent.FromHeadersNested<A> addNewFromHeader() {
    return new JWTRuleFluentImpl.FromHeadersNestedImpl();
  }
  public io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<A> addNewFromHeaderLike(io.fabric8.istio.api.security.v1beta1.JWTHeader item) {
    return new JWTRuleFluentImpl.FromHeadersNestedImpl(-1, item);
  }
  public io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<A> setNewFromHeaderLike(java.lang.Integer index,io.fabric8.istio.api.security.v1beta1.JWTHeader item) {
    return new io.fabric8.istio.api.security.v1beta1.JWTRuleFluentImpl.FromHeadersNestedImpl(index, item);
  }
  public io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<A> editFromHeader(java.lang.Integer index) {
    if (fromHeaders.size() <= index) throw new RuntimeException("Can't edit fromHeaders. Index exceeds size.");
    return setNewFromHeaderLike(index, buildFromHeader(index));
  }
  public io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<A> editFirstFromHeader() {
    if (fromHeaders.size() == 0) throw new RuntimeException("Can't edit first fromHeaders. The list is empty.");
    return setNewFromHeaderLike(0, buildFromHeader(0));
  }
  public io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<A> editLastFromHeader() {
    int index = fromHeaders.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last fromHeaders. The list is empty.");
    return setNewFromHeaderLike(index, buildFromHeader(index));
  }
  public io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<A> editMatchingFromHeader(java.util.function.Predicate<io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder> predicate) {
    int index = -1;
    for (int i=0;i<fromHeaders.size();i++) { 
    if (predicate.test(fromHeaders.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching fromHeaders. No match found.");
    return setNewFromHeaderLike(index, buildFromHeader(index));
  }
  public A addToFromParams(java.lang.Integer index,java.lang.String item) {
    if (this.fromParams == null) {this.fromParams = new java.util.ArrayList<java.lang.String>();}
    this.fromParams.add(index, item);
    return (A)this;
  }
  public A setToFromParams(java.lang.Integer index,java.lang.String item) {
    if (this.fromParams == null) {this.fromParams = new java.util.ArrayList<java.lang.String>();}
    this.fromParams.set(index, item); return (A)this;
  }
  public A addToFromParams(java.lang.String... items) {
    if (this.fromParams == null) {this.fromParams = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.fromParams.add(item);} return (A)this;
  }
  public A addAllToFromParams(java.util.Collection<java.lang.String> items) {
    if (this.fromParams == null) {this.fromParams = new java.util.ArrayList<java.lang.String>();}
    for (java.lang.String item : items) {this.fromParams.add(item);} return (A)this;
  }
  public A removeFromFromParams(java.lang.String... items) {
    for (java.lang.String item : items) {if (this.fromParams!= null){ this.fromParams.remove(item);}} return (A)this;
  }
  public A removeAllFromFromParams(java.util.Collection<java.lang.String> items) {
    for (java.lang.String item : items) {if (this.fromParams!= null){ this.fromParams.remove(item);}} return (A)this;
  }
  public java.util.List<java.lang.String> getFromParams() {
    return this.fromParams;
  }
  public java.lang.String getFromParam(java.lang.Integer index) {
    return this.fromParams.get(index);
  }
  public java.lang.String getFirstFromParam() {
    return this.fromParams.get(0);
  }
  public java.lang.String getLastFromParam() {
    return this.fromParams.get(fromParams.size() - 1);
  }
  public java.lang.String getMatchingFromParam(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: fromParams) { if(predicate.test(item)){ return item;} } return null;
  }
  public java.lang.Boolean hasMatchingFromParam(java.util.function.Predicate<java.lang.String> predicate) {
    for (java.lang.String item: fromParams) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withFromParams(java.util.List<java.lang.String> fromParams) {
    if (fromParams != null) {this.fromParams = new java.util.ArrayList(); for (java.lang.String item : fromParams){this.addToFromParams(item);}} else { this.fromParams = null;} return (A) this;
  }
  public A withFromParams(java.lang.String... fromParams) {
    if (this.fromParams != null) {this.fromParams.clear();}
    if (fromParams != null) {for (java.lang.String item :fromParams){ this.addToFromParams(item);}} return (A) this;
  }
  public java.lang.Boolean hasFromParams() {
    return fromParams != null && !fromParams.isEmpty();
  }
  public java.lang.String getIssuer() {
    return this.issuer;
  }
  public A withIssuer(java.lang.String issuer) {
    this.issuer=issuer; return (A) this;
  }
  public java.lang.Boolean hasIssuer() {
    return this.issuer != null;
  }
  public java.lang.String getJwks() {
    return this.jwks;
  }
  public A withJwks(java.lang.String jwks) {
    this.jwks=jwks; return (A) this;
  }
  public java.lang.Boolean hasJwks() {
    return this.jwks != null;
  }
  public java.lang.String getJwksUri() {
    return this.jwksUri;
  }
  public A withJwksUri(java.lang.String jwksUri) {
    this.jwksUri=jwksUri; return (A) this;
  }
  public java.lang.Boolean hasJwksUri() {
    return this.jwksUri != null;
  }
  public java.lang.String getOutputPayloadToHeader() {
    return this.outputPayloadToHeader;
  }
  public A withOutputPayloadToHeader(java.lang.String outputPayloadToHeader) {
    this.outputPayloadToHeader=outputPayloadToHeader; return (A) this;
  }
  public java.lang.Boolean hasOutputPayloadToHeader() {
    return this.outputPayloadToHeader != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JWTRuleFluentImpl that = (JWTRuleFluentImpl) o;
    if (audiences != null ? !audiences.equals(that.audiences) :that.audiences != null) return false;
    if (forwardOriginalToken != null ? !forwardOriginalToken.equals(that.forwardOriginalToken) :that.forwardOriginalToken != null) return false;
    if (fromHeaders != null ? !fromHeaders.equals(that.fromHeaders) :that.fromHeaders != null) return false;
    if (fromParams != null ? !fromParams.equals(that.fromParams) :that.fromParams != null) return false;
    if (issuer != null ? !issuer.equals(that.issuer) :that.issuer != null) return false;
    if (jwks != null ? !jwks.equals(that.jwks) :that.jwks != null) return false;
    if (jwksUri != null ? !jwksUri.equals(that.jwksUri) :that.jwksUri != null) return false;
    if (outputPayloadToHeader != null ? !outputPayloadToHeader.equals(that.outputPayloadToHeader) :that.outputPayloadToHeader != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(audiences,  forwardOriginalToken,  fromHeaders,  fromParams,  issuer,  jwks,  jwksUri,  outputPayloadToHeader,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (audiences != null && !audiences.isEmpty()) { sb.append("audiences:"); sb.append(audiences + ","); }
    if (forwardOriginalToken != null) { sb.append("forwardOriginalToken:"); sb.append(forwardOriginalToken + ","); }
    if (fromHeaders != null && !fromHeaders.isEmpty()) { sb.append("fromHeaders:"); sb.append(fromHeaders + ","); }
    if (fromParams != null && !fromParams.isEmpty()) { sb.append("fromParams:"); sb.append(fromParams + ","); }
    if (issuer != null) { sb.append("issuer:"); sb.append(issuer + ","); }
    if (jwks != null) { sb.append("jwks:"); sb.append(jwks + ","); }
    if (jwksUri != null) { sb.append("jwksUri:"); sb.append(jwksUri + ","); }
    if (outputPayloadToHeader != null) { sb.append("outputPayloadToHeader:"); sb.append(outputPayloadToHeader); }
    sb.append("}");
    return sb.toString();
  }
  public A withForwardOriginalToken() {
    return withForwardOriginalToken(true);
  }
  class FromHeadersNestedImpl<N> extends JWTHeaderFluentImpl<JWTRuleFluent.FromHeadersNested<N>> implements io.fabric8.istio.api.security.v1beta1.JWTRuleFluent.FromHeadersNested<N>,Nested<N>{
    FromHeadersNestedImpl(java.lang.Integer index,io.fabric8.istio.api.security.v1beta1.JWTHeader item) {
      this.index = index;
      this.builder = new JWTHeaderBuilder(this, item);
    }
    FromHeadersNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder(this);
    }
    io.fabric8.istio.api.security.v1beta1.JWTHeaderBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) JWTRuleFluentImpl.this.setToFromHeaders(index,builder.build());
    }
    public N endFromHeader() {
      return and();
    }
    
  }
  
}