/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.ServiceEntry;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryBuilder;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryFluentImpl;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryList;
import io.fabric8.istio.api.networking.v1beta1.ServiceEntryListFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class ServiceEntryListFluentImpl<A extends ServiceEntryListFluent<A>>
extends BaseFluent<A>
implements ServiceEntryListFluent<A> {
    private String apiVersion;
    private ArrayList<ServiceEntryBuilder> items = new ArrayList();
    private String kind;
    private ListMeta metadata;

    public ServiceEntryListFluentImpl() {
    }

    public ServiceEntryListFluentImpl(ServiceEntryList instance) {
        this.withApiVersion(instance.getApiVersion());
        this.withItems(instance.getItems());
        this.withKind(instance.getKind());
        this.withMetadata(instance.getMetadata());
    }

    @Override
    public String getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public A withApiVersion(String apiVersion) {
        this.apiVersion = apiVersion;
        return (A)this;
    }

    @Override
    public Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    @Override
    public A addToItems(Integer index, ServiceEntry item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ServiceEntryBuilder builder = new ServiceEntryBuilder(item);
        this._visitables.get((Object)"items").add(index >= 0 ? index.intValue() : this._visitables.get((Object)"items").size(), builder);
        this.items.add(index >= 0 ? index.intValue() : this.items.size(), builder);
        return (A)this;
    }

    @Override
    public A setToItems(Integer index, ServiceEntry item) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        ServiceEntryBuilder builder = new ServiceEntryBuilder(item);
        if (index < 0 || index >= this._visitables.get((Object)"items").size()) {
            this._visitables.get((Object)"items").add(builder);
        } else {
            this._visitables.get((Object)"items").set(index, builder);
        }
        if (index < 0 || index >= this.items.size()) {
            this.items.add(builder);
        } else {
            this.items.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToItems(ServiceEntry ... items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ServiceEntry item : items) {
            ServiceEntryBuilder builder = new ServiceEntryBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToItems(Collection<ServiceEntry> items) {
        if (this.items == null) {
            this.items = new ArrayList();
        }
        for (ServiceEntry item : items) {
            ServiceEntryBuilder builder = new ServiceEntryBuilder(item);
            this._visitables.get((Object)"items").add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(ServiceEntry ... items) {
        for (ServiceEntry item : items) {
            ServiceEntryBuilder builder = new ServiceEntryBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromItems(Collection<ServiceEntry> items) {
        for (ServiceEntry item : items) {
            ServiceEntryBuilder builder = new ServiceEntryBuilder(item);
            this._visitables.get((Object)"items").remove(builder);
            if (this.items == null) continue;
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromItems(Predicate<ServiceEntryBuilder> predicate) {
        if (this.items == null) {
            return (A)this;
        }
        Iterator<ServiceEntryBuilder> each = this.items.iterator();
        List visitables = this._visitables.get((Object)"items");
        while (each.hasNext()) {
            ServiceEntryBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<ServiceEntry> getItems() {
        return this.items != null ? ServiceEntryListFluentImpl.build(this.items) : null;
    }

    @Override
    public List<ServiceEntry> buildItems() {
        return this.items != null ? ServiceEntryListFluentImpl.build(this.items) : null;
    }

    @Override
    public ServiceEntry buildItem(Integer index) {
        return this.items.get(index).build();
    }

    @Override
    public ServiceEntry buildFirstItem() {
        return this.items.get(0).build();
    }

    @Override
    public ServiceEntry buildLastItem() {
        return this.items.get(this.items.size() - 1).build();
    }

    @Override
    public ServiceEntry buildMatchingItem(Predicate<ServiceEntryBuilder> predicate) {
        for (ServiceEntryBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingItem(Predicate<ServiceEntryBuilder> predicate) {
        for (ServiceEntryBuilder item : this.items) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withItems(List<ServiceEntry> items) {
        if (this.items != null) {
            this._visitables.get((Object)"items").removeAll(this.items);
        }
        if (items != null) {
            this.items = new ArrayList();
            for (ServiceEntry item : items) {
                this.addToItems(item);
            }
        } else {
            this.items = null;
        }
        return (A)this;
    }

    @Override
    public A withItems(ServiceEntry ... items) {
        if (this.items != null) {
            this.items.clear();
        }
        if (items != null) {
            for (ServiceEntry item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasItems() {
        return this.items != null && !this.items.isEmpty();
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> addNewItemLike(ServiceEntry item) {
        return new ItemsNestedImpl(-1, item);
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> setNewItemLike(Integer index, ServiceEntry item) {
        return new ItemsNestedImpl(index, item);
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> editItem(Integer index) {
        if (this.items.size() <= index) {
            throw new RuntimeException("Can't edit items. Index exceeds size.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> editFirstItem() {
        if (this.items.size() == 0) {
            throw new RuntimeException("Can't edit first items. The list is empty.");
        }
        return this.setNewItemLike(0, this.buildItem(0));
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> editLastItem() {
        int index = this.items.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last items. The list is empty.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public ServiceEntryListFluent.ItemsNested<A> editMatchingItem(Predicate<ServiceEntryBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.items.size(); ++i) {
            if (!predicate.test(this.items.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching items. No match found.");
        }
        return this.setNewItemLike(index, this.buildItem(index));
    }

    @Override
    public String getKind() {
        return this.kind;
    }

    @Override
    public A withKind(String kind) {
        this.kind = kind;
        return (A)this;
    }

    @Override
    public Boolean hasKind() {
        return this.kind != null;
    }

    @Override
    public ListMeta getMetadata() {
        return this.metadata;
    }

    @Override
    public A withMetadata(ListMeta metadata) {
        this.metadata = metadata;
        return (A)this;
    }

    @Override
    public Boolean hasMetadata() {
        return this.metadata != null;
    }

    @Override
    public A withNewMetadata(String _continue, Long remainingItemCount, String resourceVersion, String selfLink) {
        return this.withMetadata(new ListMeta(_continue, remainingItemCount, resourceVersion, selfLink));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceEntryListFluentImpl that = (ServiceEntryListFluentImpl)o;
        if (this.apiVersion != null ? !this.apiVersion.equals(that.apiVersion) : that.apiVersion != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        if (this.kind != null ? !this.kind.equals(that.kind) : that.kind != null) {
            return false;
        }
        return !(this.metadata != null ? !this.metadata.equals((Object)that.metadata) : that.metadata != null);
    }

    public int hashCode() {
        return Objects.hash(this.apiVersion, this.items, this.kind, this.metadata, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.apiVersion != null) {
            sb.append("apiVersion:");
            sb.append(this.apiVersion + ",");
        }
        if (this.items != null && !this.items.isEmpty()) {
            sb.append("items:");
            sb.append(this.items + ",");
        }
        if (this.kind != null) {
            sb.append("kind:");
            sb.append(this.kind + ",");
        }
        if (this.metadata != null) {
            sb.append("metadata:");
            sb.append(this.metadata);
        }
        sb.append("}");
        return sb.toString();
    }

    class ItemsNestedImpl<N>
    extends ServiceEntryFluentImpl<ServiceEntryListFluent.ItemsNested<N>>
    implements ServiceEntryListFluent.ItemsNested<N>,
    Nested<N> {
        ServiceEntryBuilder builder;
        Integer index;

        ItemsNestedImpl(Integer index, ServiceEntry item) {
            this.index = index;
            this.builder = new ServiceEntryBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.index = -1;
            this.builder = new ServiceEntryBuilder(this);
        }

        @Override
        public N and() {
            return (N)ServiceEntryListFluentImpl.this.setToItems(this.index, this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }
}

