/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.security.v1beta1;

import io.fabric8.istio.api.security.v1beta1.Operation;
import io.fabric8.istio.api.security.v1beta1.OperationFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class OperationFluentImpl<A extends OperationFluent<A>>
extends BaseFluent<A>
implements OperationFluent<A> {
    private List<String> hosts = new ArrayList<String>();
    private List<String> methods = new ArrayList<String>();
    private List<String> notHosts = new ArrayList<String>();
    private List<String> notMethods = new ArrayList<String>();
    private List<String> notPaths = new ArrayList<String>();
    private List<String> notPorts = new ArrayList<String>();
    private List<String> paths = new ArrayList<String>();
    private List<String> ports = new ArrayList<String>();

    public OperationFluentImpl() {
    }

    public OperationFluentImpl(Operation instance) {
        this.withHosts(instance.getHosts());
        this.withMethods(instance.getMethods());
        this.withNotHosts(instance.getNotHosts());
        this.withNotMethods(instance.getNotMethods());
        this.withNotPaths(instance.getNotPaths());
        this.withNotPorts(instance.getNotPorts());
        this.withPaths(instance.getPaths());
        this.withPorts(instance.getPorts());
    }

    @Override
    public A addToHosts(Integer index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToHosts(Integer index, String item) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        this.hosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToHosts(String ... items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToHosts(Collection<String> items) {
        if (this.hosts == null) {
            this.hosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.hosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromHosts(String ... items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromHosts(Collection<String> items) {
        for (String item : items) {
            if (this.hosts == null) continue;
            this.hosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getHosts() {
        return this.hosts;
    }

    @Override
    public String getHost(Integer index) {
        return this.hosts.get(index);
    }

    @Override
    public String getFirstHost() {
        return this.hosts.get(0);
    }

    @Override
    public String getLastHost() {
        return this.hosts.get(this.hosts.size() - 1);
    }

    @Override
    public String getMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingHost(Predicate<String> predicate) {
        for (String item : this.hosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withHosts(List<String> hosts) {
        if (hosts != null) {
            this.hosts = new ArrayList<String>();
            for (String item : hosts) {
                this.addToHosts(item);
            }
        } else {
            this.hosts = null;
        }
        return (A)this;
    }

    @Override
    public A withHosts(String ... hosts) {
        if (this.hosts != null) {
            this.hosts.clear();
        }
        if (hosts != null) {
            for (String item : hosts) {
                this.addToHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasHosts() {
        return this.hosts != null && !this.hosts.isEmpty();
    }

    @Override
    public A addToMethods(Integer index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToMethods(Integer index, String item) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        this.methods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToMethods(String ... items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToMethods(Collection<String> items) {
        if (this.methods == null) {
            this.methods = new ArrayList<String>();
        }
        for (String item : items) {
            this.methods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromMethods(String ... items) {
        for (String item : items) {
            if (this.methods == null) continue;
            this.methods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMethods(Collection<String> items) {
        for (String item : items) {
            if (this.methods == null) continue;
            this.methods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    @Override
    public String getMethod(Integer index) {
        return this.methods.get(index);
    }

    @Override
    public String getFirstMethod() {
        return this.methods.get(0);
    }

    @Override
    public String getLastMethod() {
        return this.methods.get(this.methods.size() - 1);
    }

    @Override
    public String getMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMethod(Predicate<String> predicate) {
        for (String item : this.methods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMethods(List<String> methods) {
        if (methods != null) {
            this.methods = new ArrayList<String>();
            for (String item : methods) {
                this.addToMethods(item);
            }
        } else {
            this.methods = null;
        }
        return (A)this;
    }

    @Override
    public A withMethods(String ... methods) {
        if (this.methods != null) {
            this.methods.clear();
        }
        if (methods != null) {
            for (String item : methods) {
                this.addToMethods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMethods() {
        return this.methods != null && !this.methods.isEmpty();
    }

    @Override
    public A addToNotHosts(Integer index, String item) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        this.notHosts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotHosts(Integer index, String item) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        this.notHosts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotHosts(String ... items) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.notHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotHosts(Collection<String> items) {
        if (this.notHosts == null) {
            this.notHosts = new ArrayList<String>();
        }
        for (String item : items) {
            this.notHosts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotHosts(String ... items) {
        for (String item : items) {
            if (this.notHosts == null) continue;
            this.notHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotHosts(Collection<String> items) {
        for (String item : items) {
            if (this.notHosts == null) continue;
            this.notHosts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotHosts() {
        return this.notHosts;
    }

    @Override
    public String getNotHost(Integer index) {
        return this.notHosts.get(index);
    }

    @Override
    public String getFirstNotHost() {
        return this.notHosts.get(0);
    }

    @Override
    public String getLastNotHost() {
        return this.notHosts.get(this.notHosts.size() - 1);
    }

    @Override
    public String getMatchingNotHost(Predicate<String> predicate) {
        for (String item : this.notHosts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotHost(Predicate<String> predicate) {
        for (String item : this.notHosts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotHosts(List<String> notHosts) {
        if (notHosts != null) {
            this.notHosts = new ArrayList<String>();
            for (String item : notHosts) {
                this.addToNotHosts(item);
            }
        } else {
            this.notHosts = null;
        }
        return (A)this;
    }

    @Override
    public A withNotHosts(String ... notHosts) {
        if (this.notHosts != null) {
            this.notHosts.clear();
        }
        if (notHosts != null) {
            for (String item : notHosts) {
                this.addToNotHosts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotHosts() {
        return this.notHosts != null && !this.notHosts.isEmpty();
    }

    @Override
    public A addToNotMethods(Integer index, String item) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        this.notMethods.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotMethods(Integer index, String item) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        this.notMethods.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotMethods(String ... items) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.notMethods.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotMethods(Collection<String> items) {
        if (this.notMethods == null) {
            this.notMethods = new ArrayList<String>();
        }
        for (String item : items) {
            this.notMethods.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotMethods(String ... items) {
        for (String item : items) {
            if (this.notMethods == null) continue;
            this.notMethods.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotMethods(Collection<String> items) {
        for (String item : items) {
            if (this.notMethods == null) continue;
            this.notMethods.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotMethods() {
        return this.notMethods;
    }

    @Override
    public String getNotMethod(Integer index) {
        return this.notMethods.get(index);
    }

    @Override
    public String getFirstNotMethod() {
        return this.notMethods.get(0);
    }

    @Override
    public String getLastNotMethod() {
        return this.notMethods.get(this.notMethods.size() - 1);
    }

    @Override
    public String getMatchingNotMethod(Predicate<String> predicate) {
        for (String item : this.notMethods) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotMethod(Predicate<String> predicate) {
        for (String item : this.notMethods) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotMethods(List<String> notMethods) {
        if (notMethods != null) {
            this.notMethods = new ArrayList<String>();
            for (String item : notMethods) {
                this.addToNotMethods(item);
            }
        } else {
            this.notMethods = null;
        }
        return (A)this;
    }

    @Override
    public A withNotMethods(String ... notMethods) {
        if (this.notMethods != null) {
            this.notMethods.clear();
        }
        if (notMethods != null) {
            for (String item : notMethods) {
                this.addToNotMethods(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotMethods() {
        return this.notMethods != null && !this.notMethods.isEmpty();
    }

    @Override
    public A addToNotPaths(Integer index, String item) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        this.notPaths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotPaths(Integer index, String item) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        this.notPaths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotPaths(String ... items) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.notPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotPaths(Collection<String> items) {
        if (this.notPaths == null) {
            this.notPaths = new ArrayList<String>();
        }
        for (String item : items) {
            this.notPaths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotPaths(String ... items) {
        for (String item : items) {
            if (this.notPaths == null) continue;
            this.notPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotPaths(Collection<String> items) {
        for (String item : items) {
            if (this.notPaths == null) continue;
            this.notPaths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotPaths() {
        return this.notPaths;
    }

    @Override
    public String getNotPath(Integer index) {
        return this.notPaths.get(index);
    }

    @Override
    public String getFirstNotPath() {
        return this.notPaths.get(0);
    }

    @Override
    public String getLastNotPath() {
        return this.notPaths.get(this.notPaths.size() - 1);
    }

    @Override
    public String getMatchingNotPath(Predicate<String> predicate) {
        for (String item : this.notPaths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotPath(Predicate<String> predicate) {
        for (String item : this.notPaths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotPaths(List<String> notPaths) {
        if (notPaths != null) {
            this.notPaths = new ArrayList<String>();
            for (String item : notPaths) {
                this.addToNotPaths(item);
            }
        } else {
            this.notPaths = null;
        }
        return (A)this;
    }

    @Override
    public A withNotPaths(String ... notPaths) {
        if (this.notPaths != null) {
            this.notPaths.clear();
        }
        if (notPaths != null) {
            for (String item : notPaths) {
                this.addToNotPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotPaths() {
        return this.notPaths != null && !this.notPaths.isEmpty();
    }

    @Override
    public A addToNotPorts(Integer index, String item) {
        if (this.notPorts == null) {
            this.notPorts = new ArrayList<String>();
        }
        this.notPorts.add(index, item);
        return (A)this;
    }

    @Override
    public A setToNotPorts(Integer index, String item) {
        if (this.notPorts == null) {
            this.notPorts = new ArrayList<String>();
        }
        this.notPorts.set(index, item);
        return (A)this;
    }

    @Override
    public A addToNotPorts(String ... items) {
        if (this.notPorts == null) {
            this.notPorts = new ArrayList<String>();
        }
        for (String item : items) {
            this.notPorts.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToNotPorts(Collection<String> items) {
        if (this.notPorts == null) {
            this.notPorts = new ArrayList<String>();
        }
        for (String item : items) {
            this.notPorts.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromNotPorts(String ... items) {
        for (String item : items) {
            if (this.notPorts == null) continue;
            this.notPorts.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromNotPorts(Collection<String> items) {
        for (String item : items) {
            if (this.notPorts == null) continue;
            this.notPorts.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getNotPorts() {
        return this.notPorts;
    }

    @Override
    public String getNotPort(Integer index) {
        return this.notPorts.get(index);
    }

    @Override
    public String getFirstNotPort() {
        return this.notPorts.get(0);
    }

    @Override
    public String getLastNotPort() {
        return this.notPorts.get(this.notPorts.size() - 1);
    }

    @Override
    public String getMatchingNotPort(Predicate<String> predicate) {
        for (String item : this.notPorts) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingNotPort(Predicate<String> predicate) {
        for (String item : this.notPorts) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withNotPorts(List<String> notPorts) {
        if (notPorts != null) {
            this.notPorts = new ArrayList<String>();
            for (String item : notPorts) {
                this.addToNotPorts(item);
            }
        } else {
            this.notPorts = null;
        }
        return (A)this;
    }

    @Override
    public A withNotPorts(String ... notPorts) {
        if (this.notPorts != null) {
            this.notPorts.clear();
        }
        if (notPorts != null) {
            for (String item : notPorts) {
                this.addToNotPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasNotPorts() {
        return this.notPorts != null && !this.notPorts.isEmpty();
    }

    @Override
    public A addToPaths(Integer index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPaths(Integer index, String item) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        this.paths.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPaths(String ... items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPaths(Collection<String> items) {
        if (this.paths == null) {
            this.paths = new ArrayList<String>();
        }
        for (String item : items) {
            this.paths.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPaths(String ... items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPaths(Collection<String> items) {
        for (String item : items) {
            if (this.paths == null) continue;
            this.paths.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPaths() {
        return this.paths;
    }

    @Override
    public String getPath(Integer index) {
        return this.paths.get(index);
    }

    @Override
    public String getFirstPath() {
        return this.paths.get(0);
    }

    @Override
    public String getLastPath() {
        return this.paths.get(this.paths.size() - 1);
    }

    @Override
    public String getMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPath(Predicate<String> predicate) {
        for (String item : this.paths) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPaths(List<String> paths) {
        if (paths != null) {
            this.paths = new ArrayList<String>();
            for (String item : paths) {
                this.addToPaths(item);
            }
        } else {
            this.paths = null;
        }
        return (A)this;
    }

    @Override
    public A withPaths(String ... paths) {
        if (this.paths != null) {
            this.paths.clear();
        }
        if (paths != null) {
            for (String item : paths) {
                this.addToPaths(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPaths() {
        return this.paths != null && !this.paths.isEmpty();
    }

    @Override
    public A addToPorts(Integer index, String item) {
        if (this.ports == null) {
            this.ports = new ArrayList<String>();
        }
        this.ports.add(index, item);
        return (A)this;
    }

    @Override
    public A setToPorts(Integer index, String item) {
        if (this.ports == null) {
            this.ports = new ArrayList<String>();
        }
        this.ports.set(index, item);
        return (A)this;
    }

    @Override
    public A addToPorts(String ... items) {
        if (this.ports == null) {
            this.ports = new ArrayList<String>();
        }
        for (String item : items) {
            this.ports.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToPorts(Collection<String> items) {
        if (this.ports == null) {
            this.ports = new ArrayList<String>();
        }
        for (String item : items) {
            this.ports.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromPorts(String ... items) {
        for (String item : items) {
            if (this.ports == null) continue;
            this.ports.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromPorts(Collection<String> items) {
        for (String item : items) {
            if (this.ports == null) continue;
            this.ports.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getPorts() {
        return this.ports;
    }

    @Override
    public String getPort(Integer index) {
        return this.ports.get(index);
    }

    @Override
    public String getFirstPort() {
        return this.ports.get(0);
    }

    @Override
    public String getLastPort() {
        return this.ports.get(this.ports.size() - 1);
    }

    @Override
    public String getMatchingPort(Predicate<String> predicate) {
        for (String item : this.ports) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingPort(Predicate<String> predicate) {
        for (String item : this.ports) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withPorts(List<String> ports) {
        if (ports != null) {
            this.ports = new ArrayList<String>();
            for (String item : ports) {
                this.addToPorts(item);
            }
        } else {
            this.ports = null;
        }
        return (A)this;
    }

    @Override
    public A withPorts(String ... ports) {
        if (this.ports != null) {
            this.ports.clear();
        }
        if (ports != null) {
            for (String item : ports) {
                this.addToPorts(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasPorts() {
        return this.ports != null && !this.ports.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OperationFluentImpl that = (OperationFluentImpl)o;
        if (this.hosts != null ? !this.hosts.equals(that.hosts) : that.hosts != null) {
            return false;
        }
        if (this.methods != null ? !this.methods.equals(that.methods) : that.methods != null) {
            return false;
        }
        if (this.notHosts != null ? !this.notHosts.equals(that.notHosts) : that.notHosts != null) {
            return false;
        }
        if (this.notMethods != null ? !this.notMethods.equals(that.notMethods) : that.notMethods != null) {
            return false;
        }
        if (this.notPaths != null ? !this.notPaths.equals(that.notPaths) : that.notPaths != null) {
            return false;
        }
        if (this.notPorts != null ? !this.notPorts.equals(that.notPorts) : that.notPorts != null) {
            return false;
        }
        if (this.paths != null ? !this.paths.equals(that.paths) : that.paths != null) {
            return false;
        }
        return !(this.ports != null ? !this.ports.equals(that.ports) : that.ports != null);
    }

    public int hashCode() {
        return Objects.hash(this.hosts, this.methods, this.notHosts, this.notMethods, this.notPaths, this.notPorts, this.paths, this.ports, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.hosts != null && !this.hosts.isEmpty()) {
            sb.append("hosts:");
            sb.append(this.hosts + ",");
        }
        if (this.methods != null && !this.methods.isEmpty()) {
            sb.append("methods:");
            sb.append(this.methods + ",");
        }
        if (this.notHosts != null && !this.notHosts.isEmpty()) {
            sb.append("notHosts:");
            sb.append(this.notHosts + ",");
        }
        if (this.notMethods != null && !this.notMethods.isEmpty()) {
            sb.append("notMethods:");
            sb.append(this.notMethods + ",");
        }
        if (this.notPaths != null && !this.notPaths.isEmpty()) {
            sb.append("notPaths:");
            sb.append(this.notPaths + ",");
        }
        if (this.notPorts != null && !this.notPorts.isEmpty()) {
            sb.append("notPorts:");
            sb.append(this.notPorts + ",");
        }
        if (this.paths != null && !this.paths.isEmpty()) {
            sb.append("paths:");
            sb.append(this.paths + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(this.ports);
        }
        sb.append("}");
        return sb.toString();
    }
}

