/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.HTTPHeader;
import io.fabric8.istio.api.networking.v1beta1.HTTPHeaderBuilder;
import io.fabric8.istio.api.networking.v1beta1.HTTPHeaderFluent;
import io.fabric8.istio.api.networking.v1beta1.HTTPHealthCheckConfig;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public class HTTPHealthCheckConfigFluent<A extends HTTPHealthCheckConfigFluent<A>>
extends BaseFluent<A> {
    private String host;
    private ArrayList<HTTPHeaderBuilder> httpHeaders = new ArrayList();
    private String path;
    private Integer port;
    private String scheme;
    private Map<String, Object> additionalProperties;

    public HTTPHealthCheckConfigFluent() {
    }

    public HTTPHealthCheckConfigFluent(HTTPHealthCheckConfig instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(HTTPHealthCheckConfig instance) {
        HTTPHealthCheckConfig hTTPHealthCheckConfig = instance = instance != null ? instance : new HTTPHealthCheckConfig();
        if (instance != null) {
            this.withHost(instance.getHost());
            this.withHttpHeaders(instance.getHttpHeaders());
            this.withPath(instance.getPath());
            this.withPort(instance.getPort());
            this.withScheme(instance.getScheme());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getHost() {
        return this.host;
    }

    public A withHost(String host) {
        this.host = host;
        return (A)((Object)this);
    }

    public boolean hasHost() {
        return this.host != null;
    }

    public A addToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get((Object)"httpHeaders").add(index, builder);
            this.httpHeaders.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToHttpHeaders(int index, HTTPHeader item) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
        if (index < 0 || index >= this.httpHeaders.size()) {
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        } else {
            this._visitables.get((Object)"httpHeaders").set(index, builder);
            this.httpHeaders.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            this.httpHeaders = new ArrayList();
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").add(builder);
            this.httpHeaders.add(builder);
        }
        return (A)((Object)this);
    }

    public A removeFromHttpHeaders(HTTPHeader ... items) {
        if (this.httpHeaders == null) {
            return (A)((Object)this);
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").remove((Object)builder);
            this.httpHeaders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromHttpHeaders(Collection<HTTPHeader> items) {
        if (this.httpHeaders == null) {
            return (A)((Object)this);
        }
        for (HTTPHeader item : items) {
            HTTPHeaderBuilder builder = new HTTPHeaderBuilder(item);
            this._visitables.get((Object)"httpHeaders").remove((Object)builder);
            this.httpHeaders.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromHttpHeaders(Predicate<HTTPHeaderBuilder> predicate) {
        if (this.httpHeaders == null) {
            return (A)((Object)this);
        }
        Iterator<HTTPHeaderBuilder> each = this.httpHeaders.iterator();
        List visitables = this._visitables.get((Object)"httpHeaders");
        while (each.hasNext()) {
            HTTPHeaderBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public List<HTTPHeader> buildHttpHeaders() {
        return this.httpHeaders != null ? HTTPHealthCheckConfigFluent.build(this.httpHeaders) : null;
    }

    public HTTPHeader buildHttpHeader(int index) {
        return this.httpHeaders.get(index).build();
    }

    public HTTPHeader buildFirstHttpHeader() {
        return this.httpHeaders.get(0).build();
    }

    public HTTPHeader buildLastHttpHeader() {
        return this.httpHeaders.get(this.httpHeaders.size() - 1).build();
    }

    public HTTPHeader buildMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public boolean hasMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        for (HTTPHeaderBuilder item : this.httpHeaders) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withHttpHeaders(List<HTTPHeader> httpHeaders) {
        if (this.httpHeaders != null) {
            this._visitables.get((Object)"httpHeaders").clear();
        }
        if (httpHeaders != null) {
            this.httpHeaders = new ArrayList();
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        } else {
            this.httpHeaders = null;
        }
        return (A)((Object)this);
    }

    public A withHttpHeaders(HTTPHeader ... httpHeaders) {
        if (this.httpHeaders != null) {
            this.httpHeaders.clear();
            this._visitables.remove((Object)"httpHeaders");
        }
        if (httpHeaders != null) {
            for (HTTPHeader item : httpHeaders) {
                this.addToHttpHeaders(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasHttpHeaders() {
        return this.httpHeaders != null && !this.httpHeaders.isEmpty();
    }

    public A addNewHttpHeader(String name, String value) {
        return this.addToHttpHeaders(new HTTPHeader(name, value));
    }

    public HttpHeadersNested<A> addNewHttpHeader() {
        return new HttpHeadersNested(-1, null);
    }

    public HttpHeadersNested<A> addNewHttpHeaderLike(HTTPHeader item) {
        return new HttpHeadersNested(-1, item);
    }

    public HttpHeadersNested<A> setNewHttpHeaderLike(int index, HTTPHeader item) {
        return new HttpHeadersNested(index, item);
    }

    public HttpHeadersNested<A> editHttpHeader(int index) {
        if (this.httpHeaders.size() <= index) {
            throw new RuntimeException("Can't edit httpHeaders. Index exceeds size.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editFirstHttpHeader() {
        if (this.httpHeaders.size() == 0) {
            throw new RuntimeException("Can't edit first httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(0, this.buildHttpHeader(0));
    }

    public HttpHeadersNested<A> editLastHttpHeader() {
        int index = this.httpHeaders.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last httpHeaders. The list is empty.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public HttpHeadersNested<A> editMatchingHttpHeader(Predicate<HTTPHeaderBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.httpHeaders.size(); ++i) {
            if (!predicate.test(this.httpHeaders.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching httpHeaders. No match found.");
        }
        return this.setNewHttpHeaderLike(index, this.buildHttpHeader(index));
    }

    public String getPath() {
        return this.path;
    }

    public A withPath(String path) {
        this.path = path;
        return (A)((Object)this);
    }

    public boolean hasPath() {
        return this.path != null;
    }

    public Integer getPort() {
        return this.port;
    }

    public A withPort(Integer port) {
        this.port = port;
        return (A)((Object)this);
    }

    public boolean hasPort() {
        return this.port != null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public A withScheme(String scheme) {
        this.scheme = scheme;
        return (A)((Object)this);
    }

    public boolean hasScheme() {
        return this.scheme != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HTTPHealthCheckConfigFluent that = (HTTPHealthCheckConfigFluent)((Object)o);
        if (!Objects.equals(this.host, that.host)) {
            return false;
        }
        if (!Objects.equals(this.httpHeaders, that.httpHeaders)) {
            return false;
        }
        if (!Objects.equals(this.path, that.path)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.scheme, that.scheme)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.httpHeaders, this.path, this.port, this.scheme, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.host != null) {
            sb.append("host:");
            sb.append(this.host + ",");
        }
        if (this.httpHeaders != null && !this.httpHeaders.isEmpty()) {
            sb.append("httpHeaders:");
            sb.append(this.httpHeaders + ",");
        }
        if (this.path != null) {
            sb.append("path:");
            sb.append(this.path + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.scheme != null) {
            sb.append("scheme:");
            sb.append(this.scheme + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class HttpHeadersNested<N>
    extends HTTPHeaderFluent<HttpHeadersNested<N>>
    implements Nested<N> {
        HTTPHeaderBuilder builder;
        int index;

        HttpHeadersNested(int index, HTTPHeader item) {
            this.index = index;
            this.builder = new HTTPHeaderBuilder(this, item);
        }

        public N and() {
            return (N)HTTPHealthCheckConfigFluent.this.setToHttpHeaders(this.index, this.builder.build());
        }

        public N endHttpHeader() {
            return this.and();
        }
    }
}

