/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.networking.v1beta1;

import io.fabric8.istio.api.networking.v1beta1.ProxyConfigSpec;
import io.fabric8.istio.api.networking.v1beta1.ProxyImage;
import io.fabric8.istio.api.networking.v1beta1.ProxyImageBuilder;
import io.fabric8.istio.api.networking.v1beta1.ProxyImageFluent;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelector;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorBuilder;
import io.fabric8.istio.api.type.v1beta1.WorkloadSelectorFluent;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class ProxyConfigSpecFluent<A extends ProxyConfigSpecFluent<A>>
extends BaseFluent<A> {
    private Integer concurrency;
    private Map<String, String> environmentVariables;
    private ProxyImageBuilder image;
    private WorkloadSelectorBuilder selector;
    private Map<String, Object> additionalProperties;

    public ProxyConfigSpecFluent() {
    }

    public ProxyConfigSpecFluent(ProxyConfigSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ProxyConfigSpec instance) {
        ProxyConfigSpec proxyConfigSpec = instance = instance != null ? instance : new ProxyConfigSpec();
        if (instance != null) {
            this.withConcurrency(instance.getConcurrency());
            this.withEnvironmentVariables(instance.getEnvironmentVariables());
            this.withImage(instance.getImage());
            this.withSelector(instance.getSelector());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Integer getConcurrency() {
        return this.concurrency;
    }

    public A withConcurrency(Integer concurrency) {
        this.concurrency = concurrency;
        return (A)((Object)this);
    }

    public boolean hasConcurrency() {
        return this.concurrency != null;
    }

    public A addToEnvironmentVariables(String key, String value) {
        if (this.environmentVariables == null && key != null && value != null) {
            this.environmentVariables = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.environmentVariables.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToEnvironmentVariables(Map<String, String> map) {
        if (this.environmentVariables == null && map != null) {
            this.environmentVariables = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.environmentVariables.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvironmentVariables(String key) {
        if (this.environmentVariables == null) {
            return (A)((Object)this);
        }
        if (key != null && this.environmentVariables != null) {
            this.environmentVariables.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromEnvironmentVariables(Map<String, String> map) {
        if (this.environmentVariables == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.environmentVariables == null) continue;
                this.environmentVariables.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public <K, V> A withEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables == null ? null : new LinkedHashMap<String, String>(environmentVariables);
        return (A)((Object)this);
    }

    public boolean hasEnvironmentVariables() {
        return this.environmentVariables != null;
    }

    public ProxyImage buildImage() {
        return this.image != null ? this.image.build() : null;
    }

    public A withImage(ProxyImage image) {
        this._visitables.remove((Object)"image");
        if (image != null) {
            this.image = new ProxyImageBuilder(image);
            this._visitables.get((Object)"image").add(this.image);
        } else {
            this.image = null;
            this._visitables.get((Object)"image").remove((Object)this.image);
        }
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A withNewImage(String imageType) {
        return this.withImage(new ProxyImage(imageType));
    }

    public ImageNested<A> withNewImage() {
        return new ImageNested(null);
    }

    public ImageNested<A> withNewImageLike(ProxyImage item) {
        return new ImageNested(item);
    }

    public ImageNested<A> editImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(null));
    }

    public ImageNested<A> editOrNewImage() {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(new ProxyImageBuilder().build()));
    }

    public ImageNested<A> editOrNewImageLike(ProxyImage item) {
        return this.withNewImageLike(Optional.ofNullable(this.buildImage()).orElse(item));
    }

    public WorkloadSelector buildSelector() {
        return this.selector != null ? this.selector.build() : null;
    }

    public A withSelector(WorkloadSelector selector) {
        this._visitables.remove((Object)"selector");
        if (selector != null) {
            this.selector = new WorkloadSelectorBuilder(selector);
            this._visitables.get((Object)"selector").add(this.selector);
        } else {
            this.selector = null;
            this._visitables.get((Object)"selector").remove((Object)this.selector);
        }
        return (A)((Object)this);
    }

    public boolean hasSelector() {
        return this.selector != null;
    }

    public SelectorNested<A> withNewSelector() {
        return new SelectorNested(null);
    }

    public SelectorNested<A> withNewSelectorLike(WorkloadSelector item) {
        return new SelectorNested(item);
    }

    public SelectorNested<A> editTypeSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(null));
    }

    public SelectorNested<A> editOrNewSelector() {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(new WorkloadSelectorBuilder().build()));
    }

    public SelectorNested<A> editOrNewSelectorLike(WorkloadSelector item) {
        return this.withNewSelectorLike(Optional.ofNullable(this.buildSelector()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ProxyConfigSpecFluent that = (ProxyConfigSpecFluent)((Object)o);
        if (!Objects.equals(this.concurrency, that.concurrency)) {
            return false;
        }
        if (!Objects.equals(this.environmentVariables, that.environmentVariables)) {
            return false;
        }
        if (!Objects.equals((Object)this.image, (Object)that.image)) {
            return false;
        }
        if (!Objects.equals((Object)this.selector, (Object)that.selector)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.concurrency, this.environmentVariables, this.image, this.selector, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.concurrency != null) {
            sb.append("concurrency:");
            sb.append(this.concurrency + ",");
        }
        if (this.environmentVariables != null && !this.environmentVariables.isEmpty()) {
            sb.append("environmentVariables:");
            sb.append(this.environmentVariables + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append((Object)((Object)this.image) + ",");
        }
        if (this.selector != null) {
            sb.append("selector:");
            sb.append((Object)((Object)this.selector) + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class SelectorNested<N>
    extends WorkloadSelectorFluent<SelectorNested<N>>
    implements Nested<N> {
        WorkloadSelectorBuilder builder;

        SelectorNested(WorkloadSelector item) {
            this.builder = new WorkloadSelectorBuilder(this, item);
        }

        public N and() {
            return (N)ProxyConfigSpecFluent.this.withSelector(this.builder.build());
        }

        public N endTypeSelector() {
            return this.and();
        }
    }

    public class ImageNested<N>
    extends ProxyImageFluent<ImageNested<N>>
    implements Nested<N> {
        ProxyImageBuilder builder;

        ImageNested(ProxyImage item) {
            this.builder = new ProxyImageBuilder(this, item);
        }

        public N and() {
            return (N)ProxyConfigSpecFluent.this.withImage(this.builder.build());
        }

        public N endImage() {
            return this.and();
        }
    }
}

