/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.api.api.networking.v1alpha3;

import io.fabric8.istio.api.api.networking.v1alpha3.WorkloadEntry;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public class WorkloadEntryFluent<A extends WorkloadEntryFluent<A>>
extends BaseFluent<A> {
    private String address;
    private Map<String, String> labels;
    private String locality;
    private String network;
    private Map<String, Long> ports;
    private String serviceAccount;
    private Long weight;
    private Map<String, Object> additionalProperties;

    public WorkloadEntryFluent() {
    }

    public WorkloadEntryFluent(WorkloadEntry instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(WorkloadEntry instance) {
        WorkloadEntry workloadEntry = instance = instance != null ? instance : new WorkloadEntry();
        if (instance != null) {
            this.withAddress(instance.getAddress());
            this.withLabels(instance.getLabels());
            this.withLocality(instance.getLocality());
            this.withNetwork(instance.getNetwork());
            this.withPorts(instance.getPorts());
            this.withServiceAccount(instance.getServiceAccount());
            this.withWeight(instance.getWeight());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public String getAddress() {
        return this.address;
    }

    public A withAddress(String address) {
        this.address = address;
        return (A)((Object)this);
    }

    public boolean hasAddress() {
        return this.address != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public String getLocality() {
        return this.locality;
    }

    public A withLocality(String locality) {
        this.locality = locality;
        return (A)((Object)this);
    }

    public boolean hasLocality() {
        return this.locality != null;
    }

    public String getNetwork() {
        return this.network;
    }

    public A withNetwork(String network) {
        this.network = network;
        return (A)((Object)this);
    }

    public boolean hasNetwork() {
        return this.network != null;
    }

    public A addToPorts(String key, Long value) {
        if (this.ports == null && key != null && value != null) {
            this.ports = new LinkedHashMap<String, Long>();
        }
        if (key != null && value != null) {
            this.ports.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToPorts(Map<String, Long> map) {
        if (this.ports == null && map != null) {
            this.ports = new LinkedHashMap<String, Long>();
        }
        if (map != null) {
            this.ports.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(String key) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        if (key != null && this.ports != null) {
            this.ports.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromPorts(Map<String, Long> map) {
        if (this.ports == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.ports == null) continue;
                this.ports.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Long> getPorts() {
        return this.ports;
    }

    public <K, V> A withPorts(Map<String, Long> ports) {
        this.ports = ports == null ? null : new LinkedHashMap<String, Long>(ports);
        return (A)((Object)this);
    }

    public boolean hasPorts() {
        return this.ports != null;
    }

    public String getServiceAccount() {
        return this.serviceAccount;
    }

    public A withServiceAccount(String serviceAccount) {
        this.serviceAccount = serviceAccount;
        return (A)((Object)this);
    }

    public boolean hasServiceAccount() {
        return this.serviceAccount != null;
    }

    public Long getWeight() {
        return this.weight;
    }

    public A withWeight(Long weight) {
        this.weight = weight;
        return (A)((Object)this);
    }

    public boolean hasWeight() {
        return this.weight != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        WorkloadEntryFluent that = (WorkloadEntryFluent)((Object)o);
        if (!Objects.equals(this.address, that.address)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.locality, that.locality)) {
            return false;
        }
        if (!Objects.equals(this.network, that.network)) {
            return false;
        }
        if (!Objects.equals(this.ports, that.ports)) {
            return false;
        }
        if (!Objects.equals(this.serviceAccount, that.serviceAccount)) {
            return false;
        }
        if (!Objects.equals(this.weight, that.weight)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.labels, this.locality, this.network, this.ports, this.serviceAccount, this.weight, this.additionalProperties, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.address != null) {
            sb.append("address:");
            sb.append(this.address + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(String.valueOf(this.labels) + ",");
        }
        if (this.locality != null) {
            sb.append("locality:");
            sb.append(this.locality + ",");
        }
        if (this.network != null) {
            sb.append("network:");
            sb.append(this.network + ",");
        }
        if (this.ports != null && !this.ports.isEmpty()) {
            sb.append("ports:");
            sb.append(String.valueOf(this.ports) + ",");
        }
        if (this.serviceAccount != null) {
            sb.append("serviceAccount:");
            sb.append(this.serviceAccount + ",");
        }
        if (this.weight != null) {
            sb.append("weight:");
            sb.append(this.weight + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }
}

