/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.mock;

import io.fabric8.istio.client.IstioClient;
import io.fabric8.istio.client.NamespacedIstioClient;
import io.fabric8.istio.mock.EnableIstioMockClient;
import io.fabric8.istio.mock.IstioMockServer;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.kubernetes.client.server.mock.KubernetesMockServerExtension;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.jupiter.api.extension.ExtensionContext;

public class IstioMockServerExtension
extends KubernetesMockServerExtension {
    private IstioMockServer mockServer;
    private NamespacedIstioClient istioClient;

    protected void destroy() {
        this.mockServer.destroy();
        this.istioClient.close();
    }

    protected Class<?> getClientType() {
        return IstioClient.class;
    }

    protected Class<?> getKubernetesMockServerType() {
        return IstioMockServer.class;
    }

    protected void initializeKubernetesClientAndMockServer(Class<?> testClass) {
        EnableIstioMockClient a = testClass.getAnnotation(EnableIstioMockClient.class);
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mockServer = a.crud() ? new IstioMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), a.https()) : new IstioMockServer(a.https());
        this.mockServer.init();
        this.istioClient = this.mockServer.createIstio();
    }

    protected void setFieldIfKubernetesClientOrMockServer(ExtensionContext context, boolean isStatic, Field field) throws IllegalAccessException {
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getClientType(), (i, f) -> f.set(i, this.istioClient));
        this.setFieldIfEqualsToProvidedType(context, isStatic, field, this.getKubernetesMockServerType(), (i, f) -> f.set(i, (Object)this.mockServer));
    }
}

