/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.istio.mock;

import io.fabric8.istio.client.IstioClient;
import io.fabric8.istio.mock.IstioMockServer;
import io.fabric8.kubernetes.client.server.mock.KubernetesMixedDispatcher;
import io.fabric8.mockwebserver.Context;
import io.fabric8.mockwebserver.ServerRequest;
import io.fabric8.mockwebserver.ServerResponse;
import io.fabric8.mockwebserver.dsl.MockServerExpectation;
import java.util.HashMap;
import java.util.Queue;
import okhttp3.mockwebserver.Dispatcher;
import okhttp3.mockwebserver.MockWebServer;
import org.junit.rules.ExternalResource;

public class IstioServer
extends ExternalResource {
    protected IstioMockServer mock;
    private IstioClient client;
    private final boolean https;
    private final boolean crudMode;

    public IstioServer() {
        this(true, false);
    }

    public IstioServer(boolean https) {
        this(https, false);
    }

    public IstioServer(boolean https, boolean crudMode) {
        this.https = https;
        this.crudMode = crudMode;
    }

    public void before() {
        HashMap<ServerRequest, Queue<ServerResponse>> responses = new HashMap<ServerRequest, Queue<ServerResponse>>();
        this.mock = this.crudMode ? new IstioMockServer(new Context(), new MockWebServer(), responses, (Dispatcher)new KubernetesMixedDispatcher(responses), true) : new IstioMockServer(this.https);
        this.mock.init();
        this.client = this.mock.createIstio();
    }

    public void after() {
        this.mock.destroy();
        this.client.close();
    }

    public IstioClient getIstioClient() {
        return this.client;
    }

    public MockServerExpectation expect() {
        return this.mock.expect();
    }
}

