

                        

package io.fabric8.knative.client.duck.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.duck.v1alpha1.DoneableChannelable;
import io.fabric8.knative.duck.v1alpha1.Channelable;
import io.fabric8.knative.duck.v1alpha1.ChannelableList;
import io.fabric8.knative.duck.v1alpha1.DoneableChannelable;

import java.util.Map;
import java.util.TreeMap;


public class ChannelableOperationsImpl extends HasMetadataOperation<Channelable, ChannelableList, DoneableChannelable, Resource<Channelable, DoneableChannelable>> {

  public ChannelableOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ChannelableOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("duck.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("channelables"));
    this.type = Channelable.class;
    this.listType = ChannelableList.class;
    this.doneableType = DoneableChannelable.class;
  }

  public ChannelableOperationsImpl newInstance(OperationContext context) {
    return new ChannelableOperationsImpl(context);
  }
}
