

                        

package io.fabric8.knative.client.duck.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.duck.v1beta1.internal.SubscribableOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.knative.duck.v1beta1.Subscribable;
import io.fabric8.knative.duck.v1beta1.SubscribableBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SubscribableHandler implements ResourceHandler<Subscribable, SubscribableBuilder> {

  @Override
  public String getKind() {
    return Subscribable.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "duck.knative.dev/v1beta1";
      }

  @Override
  public Subscribable create(OkHttpClient client, Config config, String namespace, Subscribable item) {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Subscribable replace(OkHttpClient client, Config config, String namespace, Subscribable item) {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Subscribable reload(OkHttpClient client, Config config, String namespace, Subscribable item) {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public SubscribableBuilder edit(Subscribable item) {
    return new SubscribableBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Subscribable item) {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Subscribable item, Watcher<Subscribable> watcher) {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Subscribable item, String resourceVersion, Watcher<Subscribable> watcher) {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Subscribable waitUntilReady(OkHttpClient client, Config config, String namespace, Subscribable item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Subscribable waitUntilCondition(OkHttpClient client, Config config, String namespace, Subscribable item, Predicate<Subscribable> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SubscribableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
