

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.BrokerOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.knative.eventing.v1alpha1.Broker;
import io.fabric8.knative.eventing.v1alpha1.BrokerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class BrokerHandler implements ResourceHandler<Broker, BrokerBuilder> {

  @Override
  public String getKind() {
    return Broker.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1alpha1";
      }

  @Override
  public Broker create(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Broker replace(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Broker reload(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public BrokerBuilder edit(Broker item) {
    return new BrokerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Broker item, Watcher<Broker> watcher) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Broker item, String resourceVersion, Watcher<Broker> watcher) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Broker waitUntilReady(OkHttpClient client, Config config, String namespace, Broker item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Broker waitUntilCondition(OkHttpClient client, Config config, String namespace, Broker item, Predicate<Broker> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
