

                        

package io.fabric8.knative.client.flows.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.flows.v1alpha1.DoneableSequence;
import io.fabric8.knative.flows.v1alpha1.Sequence;
import io.fabric8.knative.flows.v1alpha1.SequenceList;
import io.fabric8.knative.flows.v1alpha1.DoneableSequence;

import java.util.Map;
import java.util.TreeMap;


public class SequenceOperationsImpl extends HasMetadataOperation<Sequence, SequenceList, DoneableSequence, Resource<Sequence, DoneableSequence>> {

  public SequenceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SequenceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("flows.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("sequences"));
    this.type = Sequence.class;
    this.listType = SequenceList.class;
    this.doneableType = DoneableSequence.class;
  }

  public SequenceOperationsImpl newInstance(OperationContext context) {
    return new SequenceOperationsImpl(context);
  }
}
