

                        

package io.fabric8.knative.client.legacysources.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.legacysources.v1alpha1.DoneableSinkBinding;
import io.fabric8.knative.legacysources.v1alpha1.SinkBinding;
import io.fabric8.knative.legacysources.v1alpha1.SinkBindingList;
import io.fabric8.knative.legacysources.v1alpha1.DoneableSinkBinding;

import java.util.Map;
import java.util.TreeMap;


public class SinkBindingOperationsImpl extends HasMetadataOperation<SinkBinding, SinkBindingList, DoneableSinkBinding, Resource<SinkBinding, DoneableSinkBinding>> {

  public SinkBindingOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SinkBindingOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("legacysources.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("sinkbindings"));
    this.type = SinkBinding.class;
    this.listType = SinkBindingList.class;
    this.doneableType = DoneableSinkBinding.class;
  }

  public SinkBindingOperationsImpl newInstance(OperationContext context) {
    return new SinkBindingOperationsImpl(context);
  }
}
