

                        

package io.fabric8.knative.client.serving.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.serving.v1alpha1.internal.RouteOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.knative.serving.v1alpha1.Route;
import io.fabric8.knative.serving.v1alpha1.RouteBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class RouteHandler implements ResourceHandler<Route, RouteBuilder> {

  @Override
  public String getKind() {
    return Route.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1alpha1";
      }

  @Override
  public Route create(OkHttpClient client, Config config, String namespace, Route item) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Route replace(OkHttpClient client, Config config, String namespace, Route item) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Route reload(OkHttpClient client, Config config, String namespace, Route item) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public RouteBuilder edit(Route item) {
    return new RouteBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Route item) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Route item, Watcher<Route> watcher) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Route item, String resourceVersion, Watcher<Route> watcher) {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Route waitUntilReady(OkHttpClient client, Config config, String namespace, Route item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Route waitUntilCondition(OkHttpClient client, Config config, String namespace, Route item, Predicate<Route> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RouteOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
