/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.knative.client.duck.v1alpha1.handlers;

import io.fabric8.knative.client.duck.v1alpha1.internal.ResourceOperationsImpl;
import io.fabric8.knative.duck.v1alpha1.Resource;
import io.fabric8.knative.duck.v1alpha1.ResourceBuilder;
import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Deletable;
import io.fabric8.kubernetes.client.dsl.Gettable;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class ResourceHandler
implements io.fabric8.kubernetes.client.ResourceHandler<Resource, ResourceBuilder> {
    public String getKind() {
        return Resource.class.getSimpleName();
    }

    public String getApiVersion() {
        return "duck.knative.dev/v1beta1";
    }

    public Resource create(OkHttpClient client, Config config, String namespace, Resource item) {
        return (Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create((Object[])new Resource[0]);
    }

    public Resource replace(OkHttpClient client, Config config, String namespace, Resource item) {
        return (Resource)((io.fabric8.kubernetes.client.dsl.Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace((Object)item);
    }

    public Resource reload(OkHttpClient client, Config config, String namespace, Resource item) {
        return (Resource)((Gettable)((io.fabric8.kubernetes.client.dsl.Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    public ResourceBuilder edit(Resource item) {
        return new ResourceBuilder(item);
    }

    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Resource item) {
        return (Boolean)((Deletable)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy)).delete();
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Resource item, Watcher<Resource> watcher) {
        return (Watch)((io.fabric8.kubernetes.client.dsl.Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    public Watch watch(OkHttpClient client, Config config, String namespace, Resource item, String resourceVersion, Watcher<Resource> watcher) {
        return (Watch)((io.fabric8.kubernetes.client.dsl.Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    public Resource waitUntilReady(OkHttpClient client, Config config, String namespace, Resource item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Resource)((io.fabric8.kubernetes.client.dsl.Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    public Resource waitUntilCondition(OkHttpClient client, Config config, String namespace, Resource item, Predicate<Resource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Resource)((io.fabric8.kubernetes.client.dsl.Resource)new ResourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

