

                                          

package io.fabric8.knative.client.duck.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.duck.v1alpha1.DoneableSubscribableType;
import io.fabric8.knative.duck.v1alpha1.SubscribableType;
import io.fabric8.knative.duck.v1alpha1.SubscribableTypeList;
import io.fabric8.knative.duck.v1alpha1.DoneableSubscribableType;

import java.util.Map;
import java.util.TreeMap;


public class SubscribableTypeOperationsImpl extends HasMetadataOperation<SubscribableType, SubscribableTypeList, DoneableSubscribableType, Resource<SubscribableType, DoneableSubscribableType>> {

  public SubscribableTypeOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public SubscribableTypeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("duck.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("subscribabletypes"));
    this.type = SubscribableType.class;
    this.listType = SubscribableTypeList.class;
    this.doneableType = DoneableSubscribableType.class;
  }

  public SubscribableTypeOperationsImpl newInstance(OperationContext context) {
    return new SubscribableTypeOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
