

                                          

package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1alpha1.DoneableEventType;
import io.fabric8.knative.eventing.v1alpha1.EventType;
import io.fabric8.knative.eventing.v1alpha1.EventTypeList;
import io.fabric8.knative.eventing.v1alpha1.DoneableEventType;

import java.util.Map;
import java.util.TreeMap;


public class EventTypeOperationsImpl extends HasMetadataOperation<EventType, EventTypeList, DoneableEventType, Resource<EventType, DoneableEventType>> {

  public EventTypeOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public EventTypeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("eventing.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("eventtypes"));
    this.type = EventType.class;
    this.listType = EventTypeList.class;
    this.doneableType = DoneableEventType.class;
  }

  public EventTypeOperationsImpl newInstance(OperationContext context) {
    return new EventTypeOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
