

                            

package io.fabric8.knative.client.flows.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.flows.v1alpha1.internal.ParallelOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.knative.flows.v1alpha1.Parallel;
import io.fabric8.knative.flows.v1alpha1.ParallelBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ParallelHandler implements ResourceHandler<Parallel, ParallelBuilder> {

  @Override
  public String getKind() {
    return Parallel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "flows.knative.dev/v1alpha1";
      }

  @Override
  public Parallel create(OkHttpClient client, Config config, String namespace, Parallel item) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Parallel replace(OkHttpClient client, Config config, String namespace, Parallel item) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Parallel reload(OkHttpClient client, Config config, String namespace, Parallel item) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ParallelBuilder edit(Parallel item) {
    return new ParallelBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Parallel item) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Parallel item, Watcher<Parallel> watcher) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Parallel item, String resourceVersion, Watcher<Parallel> watcher) {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Parallel waitUntilReady(OkHttpClient client, Config config, String namespace, Parallel item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Parallel waitUntilCondition(OkHttpClient client, Config config, String namespace, Parallel item, Predicate<Parallel> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ParallelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
