

                            

package io.fabric8.knative.client.legacysources.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.legacysources.v1alpha1.internal.ApiServerSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.knative.legacysources.v1alpha1.ApiServerSource;
import io.fabric8.knative.legacysources.v1alpha1.ApiServerSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ApiServerSourceHandler implements ResourceHandler<ApiServerSource, ApiServerSourceBuilder> {

  @Override
  public String getKind() {
    return ApiServerSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "legacysources.knative.dev/v1alpha1";
      }

  @Override
  public ApiServerSource create(OkHttpClient client, Config config, String namespace, ApiServerSource item) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ApiServerSource replace(OkHttpClient client, Config config, String namespace, ApiServerSource item) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ApiServerSource reload(OkHttpClient client, Config config, String namespace, ApiServerSource item) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ApiServerSourceBuilder edit(ApiServerSource item) {
    return new ApiServerSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ApiServerSource item) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ApiServerSource item, Watcher<ApiServerSource> watcher) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ApiServerSource item, String resourceVersion, Watcher<ApiServerSource> watcher) {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public ApiServerSource waitUntilReady(OkHttpClient client, Config config, String namespace, ApiServerSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ApiServerSource waitUntilCondition(OkHttpClient client, Config config, String namespace, ApiServerSource item, Predicate<ApiServerSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ApiServerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
