

                                          

package io.fabric8.knative.client.legacysources.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.legacysources.v1alpha1.DoneableContainerSource;
import io.fabric8.knative.legacysources.v1alpha1.ContainerSource;
import io.fabric8.knative.legacysources.v1alpha1.ContainerSourceList;
import io.fabric8.knative.legacysources.v1alpha1.DoneableContainerSource;

import java.util.Map;
import java.util.TreeMap;


public class ContainerSourceOperationsImpl extends HasMetadataOperation<ContainerSource, ContainerSourceList, DoneableContainerSource, Resource<ContainerSource, DoneableContainerSource>> {

  public ContainerSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ContainerSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("legacysources.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("containersources"));
    this.type = ContainerSource.class;
    this.listType = ContainerSourceList.class;
    this.doneableType = DoneableContainerSource.class;
  }

  public ContainerSourceOperationsImpl newInstance(OperationContext context) {
    return new ContainerSourceOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
