

                                          

package io.fabric8.knative.client.serving.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1alpha1.DoneableConfiguration;
import io.fabric8.knative.serving.v1alpha1.Configuration;
import io.fabric8.knative.serving.v1alpha1.ConfigurationList;
import io.fabric8.knative.serving.v1alpha1.DoneableConfiguration;

import java.util.Map;
import java.util.TreeMap;


public class ConfigurationOperationsImpl extends HasMetadataOperation<Configuration, ConfigurationList, DoneableConfiguration, Resource<Configuration, DoneableConfiguration>> {

  public ConfigurationOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ConfigurationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("serving.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("configurations"));
    this.type = Configuration.class;
    this.listType = ConfigurationList.class;
    this.doneableType = DoneableConfiguration.class;
  }

  public ConfigurationOperationsImpl newInstance(OperationContext context) {
    return new ConfigurationOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
