

                            

package io.fabric8.knative.client.serving.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.serving.v1beta1.internal.ConfigurationOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.knative.serving.v1beta1.Configuration;
import io.fabric8.knative.serving.v1beta1.ConfigurationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ConfigurationHandler implements ResourceHandler<Configuration, ConfigurationBuilder> {

  @Override
  public String getKind() {
    return Configuration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1beta1";
      }

  @Override
  public Configuration create(OkHttpClient client, Config config, String namespace, Configuration item) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Configuration replace(OkHttpClient client, Config config, String namespace, Configuration item) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Configuration reload(OkHttpClient client, Config config, String namespace, Configuration item) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ConfigurationBuilder edit(Configuration item) {
    return new ConfigurationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Configuration item) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Configuration item, Watcher<Configuration> watcher) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Configuration item, String resourceVersion, Watcher<Configuration> watcher) {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Configuration waitUntilReady(OkHttpClient client, Config config, String namespace, Configuration item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Configuration waitUntilCondition(OkHttpClient client, Config config, String namespace, Configuration item, Predicate<Configuration> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
