

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.EventTypeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.v1alpha1.EventType;
import io.fabric8.knative.eventing.v1alpha1.EventTypeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class EventTypeHandler implements ResourceHandler<EventType, EventTypeBuilder> {

  @Override
  public String getKind() {
    return EventType.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1alpha1";
      }

  @Override
  public EventType create(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public EventType replace(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public EventType reload(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public EventTypeBuilder edit(EventType item) {
    return new EventTypeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EventType item, Watcher<EventType> watcher) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EventType item, String resourceVersion, Watcher<EventType> watcher) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EventType item, ListOptions listOptions, Watcher<EventType> watcher) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public EventType waitUntilReady(OkHttpClient client, Config config, String namespace, EventType item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public EventType waitUntilCondition(OkHttpClient client, Config config, String namespace, EventType item, Predicate<EventType> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
