

                        

package io.fabric8.knative.client.messaging.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.messaging.v1alpha1.internal.ChannelOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.messaging.v1alpha1.Channel;
import io.fabric8.knative.messaging.v1alpha1.ChannelBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ChannelHandler implements ResourceHandler<Channel, ChannelBuilder> {

  @Override
  public String getKind() {
    return Channel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1alpha1";
      }

  @Override
  public Channel create(OkHttpClient client, Config config, String namespace, Channel item) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Channel replace(OkHttpClient client, Config config, String namespace, Channel item) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Channel reload(OkHttpClient client, Config config, String namespace, Channel item) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ChannelBuilder edit(Channel item) {
    return new ChannelBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Channel item) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Channel item, Watcher<Channel> watcher) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Channel item, String resourceVersion, Watcher<Channel> watcher) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Channel item, ListOptions listOptions, Watcher<Channel> watcher) {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public Channel waitUntilReady(OkHttpClient client, Config config, String namespace, Channel item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Channel waitUntilCondition(OkHttpClient client, Config config, String namespace, Channel item, Predicate<Channel> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
