

                        

package io.fabric8.knative.client.messaging.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.messaging.v1alpha1.internal.SubscriptionOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.messaging.v1alpha1.Subscription;
import io.fabric8.knative.messaging.v1alpha1.SubscriptionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SubscriptionHandler implements ResourceHandler<Subscription, SubscriptionBuilder> {

  @Override
  public String getKind() {
    return Subscription.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1alpha1";
      }

  @Override
  public Subscription create(OkHttpClient client, Config config, String namespace, Subscription item) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Subscription replace(OkHttpClient client, Config config, String namespace, Subscription item) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Subscription reload(OkHttpClient client, Config config, String namespace, Subscription item) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public SubscriptionBuilder edit(Subscription item) {
    return new SubscriptionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Subscription item) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, Watcher<Subscription> watcher) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, String resourceVersion, Watcher<Subscription> watcher) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Subscription item, ListOptions listOptions, Watcher<Subscription> watcher) {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public Subscription waitUntilReady(OkHttpClient client, Config config, String namespace, Subscription item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Subscription waitUntilCondition(OkHttpClient client, Config config, String namespace, Subscription item, Predicate<Subscription> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SubscriptionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
