

                        

package io.fabric8.knative.client.messaging.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.messaging.v1alpha1.internal.InMemoryChannelOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannel;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class InMemoryChannelHandler implements ResourceHandler<InMemoryChannel, InMemoryChannelBuilder> {

  @Override
  public String getKind() {
    return InMemoryChannel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1alpha1";
      }

  @Override
  public InMemoryChannel create(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public InMemoryChannel replace(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public InMemoryChannel reload(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public InMemoryChannelBuilder edit(InMemoryChannel item) {
    return new InMemoryChannelBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, InMemoryChannel item, Watcher<InMemoryChannel> watcher) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, InMemoryChannel item, String resourceVersion, Watcher<InMemoryChannel> watcher) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, InMemoryChannel item, ListOptions listOptions, Watcher<InMemoryChannel> watcher) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public InMemoryChannel waitUntilReady(OkHttpClient client, Config config, String namespace, InMemoryChannel item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public InMemoryChannel waitUntilCondition(OkHttpClient client, Config config, String namespace, InMemoryChannel item, Predicate<InMemoryChannel> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
