

                        
      
package io.fabric8.knative.client.sources.v1beta1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1beta1.DoneableApiServerSource;
import io.fabric8.knative.sources.v1beta1.ApiServerSource;
import io.fabric8.knative.sources.v1beta1.ApiServerSourceList;
import io.fabric8.knative.sources.v1beta1.DoneableApiServerSource;

import java.util.Map;
import java.util.TreeMap;


public class ApiServerSourceOperationsImpl extends HasMetadataOperation<ApiServerSource, ApiServerSourceList, DoneableApiServerSource, Resource<ApiServerSource, DoneableApiServerSource>> {

  public ApiServerSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ApiServerSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("apiserversources"));
    this.type = ApiServerSource.class;
    this.listType = ApiServerSourceList.class;
    this.doneableType = DoneableApiServerSource.class;
  }

  public ApiServerSourceOperationsImpl newInstance(OperationContext context) {
    return new ApiServerSourceOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
