

                        
      
package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.DoneableAwsSqsSource;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSource;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.AwsSqsSourceList;
import io.fabric8.knative.eventing.contrib.awssqs.v1alpha1.DoneableAwsSqsSource;

import java.util.Map;
import java.util.TreeMap;


public class AwsSqsSourceOperationsImpl extends HasMetadataOperation<AwsSqsSource, AwsSqsSourceList, DoneableAwsSqsSource, Resource<AwsSqsSource, DoneableAwsSqsSource>> {

  public AwsSqsSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public AwsSqsSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("awssqssources"));
    this.type = AwsSqsSource.class;
    this.listType = AwsSqsSourceList.class;
    this.doneableType = DoneableAwsSqsSource.class;
  }

  public AwsSqsSourceOperationsImpl newInstance(OperationContext context) {
    return new AwsSqsSourceOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
