

                        
      
package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.DoneablePrometheusSource;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSource;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.PrometheusSourceList;
import io.fabric8.knative.eventing.contrib.prometheus.v1alpha1.DoneablePrometheusSource;

import java.util.Map;
import java.util.TreeMap;


public class PrometheusSourceOperationsImpl extends HasMetadataOperation<PrometheusSource, PrometheusSourceList, DoneablePrometheusSource, Resource<PrometheusSource, DoneablePrometheusSource>> {

  public PrometheusSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PrometheusSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("prometheussources"));
    this.type = PrometheusSource.class;
    this.listType = PrometheusSourceList.class;
    this.doneableType = DoneablePrometheusSource.class;
  }

  public PrometheusSourceOperationsImpl newInstance(OperationContext context) {
    return new PrometheusSourceOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
