

                        
      
package io.fabric8.knative.client.sources.v1beta1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.sources.v1beta1.DoneablePingSource;
import io.fabric8.knative.sources.v1beta1.PingSource;
import io.fabric8.knative.sources.v1beta1.PingSourceList;
import io.fabric8.knative.sources.v1beta1.DoneablePingSource;

import java.util.Map;
import java.util.TreeMap;


public class PingSourceOperationsImpl extends HasMetadataOperation<PingSource, PingSourceList, DoneablePingSource, Resource<PingSource, DoneablePingSource>> {

  public PingSourceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public PingSourceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("sources.knative.dev")
    .withApiGroupVersion("v1beta1")
    .withPlural("pingsources"));
    this.type = PingSource.class;
    this.listType = PingSourceList.class;
    this.doneableType = DoneablePingSource.class;
  }

  public PingSourceOperationsImpl newInstance(OperationContext context) {
    return new PingSourceOperationsImpl(context);
  }

  @Override
  public boolean isResourceNamespaced() {
    return true;
  }
}
