

                        

package io.fabric8.knative.client.eventing.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1beta1.internal.KafkaSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSource;
import io.fabric8.knative.eventing.contrib.kafka.v1beta1.KafkaSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class KafkaSourceHandler implements ResourceHandler<KafkaSource, KafkaSourceBuilder> {

  @Override
  public String getKind() {
    return KafkaSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "sources.knative.dev/v1beta1";
      }

  @Override
  public KafkaSource create(OkHttpClient client, Config config, String namespace, KafkaSource item) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public KafkaSource replace(OkHttpClient client, Config config, String namespace, KafkaSource item) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public KafkaSource reload(OkHttpClient client, Config config, String namespace, KafkaSource item) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public KafkaSourceBuilder edit(KafkaSource item) {
    return new KafkaSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, KafkaSource item) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaSource item, Watcher<KafkaSource> watcher) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaSource item, String resourceVersion, Watcher<KafkaSource> watcher) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, KafkaSource item, ListOptions listOptions, Watcher<KafkaSource> watcher) {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public KafkaSource waitUntilReady(OkHttpClient client, Config config, String namespace, KafkaSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public KafkaSource waitUntilCondition(OkHttpClient client, Config config, String namespace, KafkaSource item, Predicate<KafkaSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new KafkaSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
