
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.internal.InMemoryChannelOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1alpha1.InMemoryChannel;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class InMemoryChannelHandler implements ResourceHandler<InMemoryChannel, InMemoryChannelBuilder> {

  @Override
  public String getKind() {
    return InMemoryChannel.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "messaging.knative.dev/v1alpha1";
      }

  @Override
  public InMemoryChannel create(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public InMemoryChannel replace(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public InMemoryChannel reload(OkHttpClient client, Config config, String namespace, InMemoryChannel item) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public InMemoryChannelBuilder edit(InMemoryChannel item) {
    return new InMemoryChannelBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, InMemoryChannel item) {
    if(cascading) {
      return new InMemoryChannelOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, InMemoryChannel item, Watcher<InMemoryChannel> watcher) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, InMemoryChannel item, String resourceVersion, Watcher<InMemoryChannel> watcher) {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public InMemoryChannel waitUntilReady(OkHttpClient client, Config config, String namespace, InMemoryChannel item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public InMemoryChannel waitUntilCondition(OkHttpClient client, Config config, String namespace, InMemoryChannel item, Predicate<InMemoryChannel> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new InMemoryChannelOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
