
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.internal.TriggerOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1alpha1.Trigger;
import io.fabric8.knative.eventing.v1alpha1.TriggerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class TriggerHandler implements ResourceHandler<Trigger, TriggerBuilder> {

  @Override
  public String getKind() {
    return Trigger.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1alpha1";
      }

  @Override
  public Trigger create(OkHttpClient client, Config config, String namespace, Trigger item) {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Trigger replace(OkHttpClient client, Config config, String namespace, Trigger item) {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Trigger reload(OkHttpClient client, Config config, String namespace, Trigger item) {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public TriggerBuilder edit(Trigger item) {
    return new TriggerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Trigger item) {
    if(cascading) {
      return new TriggerOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Trigger item, Watcher<Trigger> watcher) {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Trigger item, String resourceVersion, Watcher<Trigger> watcher) {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Trigger waitUntilReady(OkHttpClient client, Config config, String namespace, Trigger item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Trigger waitUntilCondition(OkHttpClient client, Config config, String namespace, Trigger item, Predicate<Trigger> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new TriggerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
