
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1alpha1.DoneableSequence;
import io.fabric8.knative.messaging.v1alpha1.Sequence;
import io.fabric8.knative.messaging.v1alpha1.SequenceList;
import io.fabric8.knative.messaging.v1alpha1.DoneableSequence;

import java.util.Map;
import java.util.TreeMap;


public class SequenceOperationsImpl extends HasMetadataOperation<Sequence, SequenceList, DoneableSequence, Resource<Sequence, DoneableSequence>> {

  public SequenceOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public SequenceOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("messaging.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("sequences"));
    this.type = Sequence.class;
    this.listType = SequenceList.class;
    this.doneableType = DoneableSequence.class;
  }

  public SequenceOperationsImpl newInstance(OperationContext context) {
    return new SequenceOperationsImpl(context);
  }
}
