
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.internal.EventTypeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1alpha1.EventType;
import io.fabric8.knative.eventing.v1alpha1.EventTypeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class EventTypeHandler implements ResourceHandler<EventType, EventTypeBuilder> {

  @Override
  public String getKind() {
    return EventType.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1alpha1";
      }

  @Override
  public EventType create(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public EventType replace(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public EventType reload(OkHttpClient client, Config config, String namespace, EventType item) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public EventTypeBuilder edit(EventType item) {
    return new EventTypeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, EventType item) {
    if(cascading) {
      return new EventTypeOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EventType item, Watcher<EventType> watcher) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, EventType item, String resourceVersion, Watcher<EventType> watcher) {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public EventType waitUntilReady(OkHttpClient client, Config config, String namespace, EventType item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public EventType waitUntilCondition(OkHttpClient client, Config config, String namespace, EventType item, Predicate<EventType> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new EventTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
