
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.internal.BrokerOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1alpha1.Broker;
import io.fabric8.knative.eventing.v1alpha1.BrokerBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class BrokerHandler implements ResourceHandler<Broker, BrokerBuilder> {

  @Override
  public String getKind() {
    return Broker.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "eventing.knative.dev/v1alpha1";
      }

  @Override
  public Broker create(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Broker replace(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Broker reload(OkHttpClient client, Config config, String namespace, Broker item) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public BrokerBuilder edit(Broker item) {
    return new BrokerBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Broker item) {
    if(cascading) {
      return new BrokerOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Broker item, Watcher<Broker> watcher) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Broker item, String resourceVersion, Watcher<Broker> watcher) {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Broker waitUntilReady(OkHttpClient client, Config config, String namespace, Broker item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Broker waitUntilCondition(OkHttpClient client, Config config, String namespace, Broker item, Predicate<Broker> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new BrokerOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
