
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.serving.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1alpha1.DoneableRoute;
import io.fabric8.knative.serving.v1alpha1.Route;
import io.fabric8.knative.serving.v1alpha1.RouteList;
import io.fabric8.knative.serving.v1alpha1.DoneableRoute;

import java.util.Map;
import java.util.TreeMap;


public class RouteOperationsImpl extends HasMetadataOperation<Route, RouteList, DoneableRoute, Resource<Route, DoneableRoute>> {

  public RouteOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public RouteOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("serving.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("routes"));
    this.type = Route.class;
    this.listType = RouteList.class;
    this.doneableType = DoneableRoute.class;
  }

  public RouteOperationsImpl newInstance(OperationContext context) {
    return new RouteOperationsImpl(context);
  }
}
