
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.serving.v1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.serving.v1.internal.ServiceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Service;
import io.fabric8.knative.serving.v1.ServiceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ServiceHandler implements ResourceHandler<Service, ServiceBuilder> {

  @Override
  public String getKind() {
    return Service.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1";
      }

  @Override
  public Service create(OkHttpClient client, Config config, String namespace, Service item) {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Service replace(OkHttpClient client, Config config, String namespace, Service item) {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Service reload(OkHttpClient client, Config config, String namespace, Service item) {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ServiceBuilder edit(Service item) {
    return new ServiceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Service item) {
    if(cascading) {
      return new ServiceOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Service item, Watcher<Service> watcher) {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Service item, String resourceVersion, Watcher<Service> watcher) {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Service waitUntilReady(OkHttpClient client, Config config, String namespace, Service item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Service waitUntilCondition(OkHttpClient client, Config config, String namespace, Service item, Predicate<Service> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ServiceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
