
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.duck.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.duck.v1alpha1.internal.SubscribableTypeOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.duck.v1alpha1.SubscribableType;
import io.fabric8.knative.duck.v1alpha1.SubscribableTypeBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class SubscribableTypeHandler implements ResourceHandler<SubscribableType, SubscribableTypeBuilder> {

  @Override
  public String getKind() {
    return SubscribableType.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "duck.knative.dev/v1alpha1";
      }

  @Override
  public SubscribableType create(OkHttpClient client, Config config, String namespace, SubscribableType item) {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public SubscribableType replace(OkHttpClient client, Config config, String namespace, SubscribableType item) {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public SubscribableType reload(OkHttpClient client, Config config, String namespace, SubscribableType item) {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public SubscribableTypeBuilder edit(SubscribableType item) {
    return new SubscribableTypeBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, SubscribableType item) {
    if(cascading) {
      return new SubscribableTypeOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, SubscribableType item, Watcher<SubscribableType> watcher) {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, SubscribableType item, String resourceVersion, Watcher<SubscribableType> watcher) {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public SubscribableType waitUntilReady(OkHttpClient client, Config config, String namespace, SubscribableType item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public SubscribableType waitUntilCondition(OkHttpClient client, Config config, String namespace, SubscribableType item, Predicate<SubscribableType> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new SubscribableTypeOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
