
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.duck.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.duck.v1alpha1.DoneableChannelable;
import io.fabric8.knative.duck.v1alpha1.Channelable;
import io.fabric8.knative.duck.v1alpha1.ChannelableList;
import io.fabric8.knative.duck.v1alpha1.DoneableChannelable;

import java.util.Map;
import java.util.TreeMap;


public class ChannelableOperationsImpl extends HasMetadataOperation<Channelable, ChannelableList, DoneableChannelable, Resource<Channelable, DoneableChannelable>> {

  public ChannelableOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public ChannelableOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("duck.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("channelables"));
    this.type = Channelable.class;
    this.listType = ChannelableList.class;
    this.doneableType = DoneableChannelable.class;
  }

  public ChannelableOperationsImpl newInstance(OperationContext context) {
    return new ChannelableOperationsImpl(context);
  }
}
