
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.duck.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.duck.v1alpha1.DoneableSubscribableType;
import io.fabric8.knative.duck.v1alpha1.SubscribableType;
import io.fabric8.knative.duck.v1alpha1.SubscribableTypeList;
import io.fabric8.knative.duck.v1alpha1.DoneableSubscribableType;

import java.util.Map;
import java.util.TreeMap;


public class SubscribableTypeOperationsImpl extends HasMetadataOperation<SubscribableType, SubscribableTypeList, DoneableSubscribableType, Resource<SubscribableType, DoneableSubscribableType>> {

  public SubscribableTypeOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public SubscribableTypeOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("duck.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("subscribabletypes"));
    this.type = SubscribableType.class;
    this.listType = SubscribableTypeList.class;
    this.doneableType = DoneableSubscribableType.class;
  }

  public SubscribableTypeOperationsImpl newInstance(OperationContext context) {
    return new SubscribableTypeOperationsImpl(context);
  }
}
