
/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

                        

package io.fabric8.knative.client.legacysources.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.legacysources.v1alpha1.internal.ContainerSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.legacysources.v1alpha1.ContainerSource;
import io.fabric8.knative.legacysources.v1alpha1.ContainerSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ContainerSourceHandler implements ResourceHandler<ContainerSource, ContainerSourceBuilder> {

  @Override
  public String getKind() {
    return ContainerSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "legacysources.knative.dev/v1alpha1";
      }

  @Override
  public ContainerSource create(OkHttpClient client, Config config, String namespace, ContainerSource item) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ContainerSource replace(OkHttpClient client, Config config, String namespace, ContainerSource item) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ContainerSource reload(OkHttpClient client, Config config, String namespace, ContainerSource item) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ContainerSourceBuilder edit(ContainerSource item) {
    return new ContainerSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, ContainerSource item) {
    if(cascading) {
      return new ContainerSourceOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerSource item, Watcher<ContainerSource> watcher) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ContainerSource item, String resourceVersion, Watcher<ContainerSource> watcher) {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public ContainerSource waitUntilReady(OkHttpClient client, Config config, String namespace, ContainerSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ContainerSource waitUntilCondition(OkHttpClient client, Config config, String namespace, ContainerSource item, Predicate<ContainerSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ContainerSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
