

                        

package io.fabric8.knative.client.eventing.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.eventing.v1alpha1.DoneableTrigger;
import io.fabric8.knative.eventing.v1alpha1.Trigger;
import io.fabric8.knative.eventing.v1alpha1.TriggerList;
import io.fabric8.knative.eventing.v1alpha1.DoneableTrigger;

import java.util.Map;
import java.util.TreeMap;


public class TriggerOperationsImpl extends HasMetadataOperation<Trigger, TriggerList, DoneableTrigger, Resource<Trigger, DoneableTrigger>> {

  public TriggerOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public TriggerOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("eventing.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("triggers"));
    this.type = Trigger.class;
    this.listType = TriggerList.class;
    this.doneableType = DoneableTrigger.class;
  }

  public TriggerOperationsImpl newInstance(OperationContext context) {
    return new TriggerOperationsImpl(context);
  }
}
