

                        

package io.fabric8.knative.client.duck.v1beta1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.duck.v1beta1.internal.ChannelableOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.duck.v1beta1.Channelable;
import io.fabric8.knative.duck.v1beta1.ChannelableBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ChannelableHandler implements ResourceHandler<Channelable, ChannelableBuilder> {

  @Override
  public String getKind() {
    return Channelable.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "duck.knative.dev/v1beta1";
      }

  @Override
  public Channelable create(OkHttpClient client, Config config, String namespace, Channelable item) {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Channelable replace(OkHttpClient client, Config config, String namespace, Channelable item) {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Channelable reload(OkHttpClient client, Config config, String namespace, Channelable item) {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ChannelableBuilder edit(Channelable item) {
    return new ChannelableBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Channelable item) {
    if(cascading) {
      return new ChannelableOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Channelable item, Watcher<Channelable> watcher) {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Channelable item, String resourceVersion, Watcher<Channelable> watcher) {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Channelable waitUntilReady(OkHttpClient client, Config config, String namespace, Channelable item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Channelable waitUntilCondition(OkHttpClient client, Config config, String namespace, Channelable item, Predicate<Channelable> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ChannelableOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
