

                        

package io.fabric8.knative.client.legacysources.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.legacysources.v1alpha1.internal.CronJobSourceOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.legacysources.v1alpha1.CronJobSource;
import io.fabric8.knative.legacysources.v1alpha1.CronJobSourceBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CronJobSourceHandler implements ResourceHandler<CronJobSource, CronJobSourceBuilder> {

  @Override
  public String getKind() {
    return CronJobSource.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "legacysources.knative.dev/v1alpha1";
      }

  @Override
  public CronJobSource create(OkHttpClient client, Config config, String namespace, CronJobSource item) {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public CronJobSource replace(OkHttpClient client, Config config, String namespace, CronJobSource item) {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public CronJobSource reload(OkHttpClient client, Config config, String namespace, CronJobSource item) {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CronJobSourceBuilder edit(CronJobSource item) {
    return new CronJobSourceBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, CronJobSource item) {
    if(cascading) {
      return new CronJobSourceOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CronJobSource item, Watcher<CronJobSource> watcher) {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CronJobSource item, String resourceVersion, Watcher<CronJobSource> watcher) {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public CronJobSource waitUntilReady(OkHttpClient client, Config config, String namespace, CronJobSource item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CronJobSource waitUntilCondition(OkHttpClient client, Config config, String namespace, CronJobSource item, Predicate<CronJobSource> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CronJobSourceOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
