

                        

package io.fabric8.knative.client.messaging.v1alpha1.internal;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.knative.messaging.v1alpha1.DoneableInMemoryChannel;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannel;
import io.fabric8.knative.messaging.v1alpha1.InMemoryChannelList;
import io.fabric8.knative.messaging.v1alpha1.DoneableInMemoryChannel;

import java.util.Map;
import java.util.TreeMap;


public class InMemoryChannelOperationsImpl extends HasMetadataOperation<InMemoryChannel, InMemoryChannelList, DoneableInMemoryChannel, Resource<InMemoryChannel, DoneableInMemoryChannel>> {

  public InMemoryChannelOperationsImpl(OkHttpClient client, Config config) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config));
  }

  public InMemoryChannelOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("messaging.knative.dev")
    .withApiGroupVersion("v1alpha1")
    .withPlural("inmemorychannels"));
    this.type = InMemoryChannel.class;
    this.listType = InMemoryChannelList.class;
    this.doneableType = DoneableInMemoryChannel.class;
  }

  public InMemoryChannelOperationsImpl newInstance(OperationContext context) {
    return new InMemoryChannelOperationsImpl(context);
  }
}
