

                        

package io.fabric8.knative.client.serving.v1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.serving.v1.internal.RevisionOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.knative.serving.v1.Revision;
import io.fabric8.knative.serving.v1.RevisionBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class RevisionHandler implements ResourceHandler<Revision, RevisionBuilder> {

  @Override
  public String getKind() {
    return Revision.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "serving.knative.dev/v1";
      }

  @Override
  public Revision create(OkHttpClient client, Config config, String namespace, Revision item) {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public Revision replace(OkHttpClient client, Config config, String namespace, Revision item) {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public Revision reload(OkHttpClient client, Config config, String namespace, Revision item) {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public RevisionBuilder edit(Revision item) {
    return new RevisionBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, Boolean cascading, Revision item) {
    if(cascading) {
      return new RevisionOperationsImpl(client, config).withItem(item).cascading(cascading).delete();
    } else {
      return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).delete(item);
    }
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Revision item, Watcher<Revision> watcher) {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, Revision item, String resourceVersion, Watcher<Revision> watcher) {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Revision waitUntilReady(OkHttpClient client, Config config, String namespace, Revision item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public Revision waitUntilCondition(OkHttpClient client, Config config, String namespace, Revision item, Predicate<Revision> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new RevisionOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
