

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitHubBindingOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBinding;
import io.fabric8.knative.eventing.contrib.github.v1alpha1.GitHubBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class GitHubBindingHandler implements ResourceHandler<GitHubBinding, GitHubBindingBuilder> {

  @Override
  public String getKind() {
    return GitHubBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "bindings.knative.dev/v1alpha1";
      }

  @Override
  public GitHubBinding create(OkHttpClient client, Config config, String namespace, GitHubBinding item) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public GitHubBinding replace(OkHttpClient client, Config config, String namespace, GitHubBinding item) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public GitHubBinding reload(OkHttpClient client, Config config, String namespace, GitHubBinding item) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public GitHubBindingBuilder edit(GitHubBinding item) {
    return new GitHubBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, GitHubBinding item) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitHubBinding item, Watcher<GitHubBinding> watcher) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitHubBinding item, String resourceVersion, Watcher<GitHubBinding> watcher) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitHubBinding item, ListOptions listOptions, Watcher<GitHubBinding> watcher) {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public GitHubBinding waitUntilReady(OkHttpClient client, Config config, String namespace, GitHubBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public GitHubBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, GitHubBinding item, Predicate<GitHubBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitHubBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
