

                        

package io.fabric8.knative.client.eventing.v1alpha1.handlers;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.knative.client.eventing.v1alpha1.internal.GitLabBindingOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBinding;
import io.fabric8.knative.eventing.contrib.gitlab.v1alpha1.GitLabBindingBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class GitLabBindingHandler implements ResourceHandler<GitLabBinding, GitLabBindingBuilder> {

  @Override
  public String getKind() {
    return GitLabBinding.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "bindings.knative.dev/v1alpha1";
      }

  @Override
  public GitLabBinding create(OkHttpClient client, Config config, String namespace, GitLabBinding item) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public GitLabBinding replace(OkHttpClient client, Config config, String namespace, GitLabBinding item) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public GitLabBinding reload(OkHttpClient client, Config config, String namespace, GitLabBinding item) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public GitLabBindingBuilder edit(GitLabBinding item) {
    return new GitLabBindingBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, GitLabBinding item) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitLabBinding item, Watcher<GitLabBinding> watcher) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitLabBinding item, String resourceVersion, Watcher<GitLabBinding> watcher) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, GitLabBinding item, ListOptions listOptions, Watcher<GitLabBinding> watcher) {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(listOptions, watcher);
  }

  @Override
  public GitLabBinding waitUntilReady(OkHttpClient client, Config config, String namespace, GitLabBinding item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public GitLabBinding waitUntilCondition(OkHttpClient client, Config config, String namespace, GitLabBinding item, Predicate<GitLabBinding> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new GitLabBindingOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
